.\" **
.\" **
.\" **  (c) Copyright 1989, 1990, 1991 Open Software Foundation, Inc.
.\" **      All Rights Reserved.
.\" **
.\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
.\" **
.\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
.\" **      Maynard, MA.  All Rights Reserved.
.\" **
.\" **
.TH uil 1X
.iX "uil"
.iX "uil" "compiler"
.SH NAME
\fBuil\fP - The user interface language compiler for X window system.
.iX "user interface language"
.iX "user interface language" "compiler"
.SH SYNOPSIS
.B uil
[\fIoptions\fP] \fIfile\fP
.SH DESCRIPTION
.NXR "User interface language" "compiler"
The 
.B uil
command invokes the UIL compiler.  The User Interface 
Language (UIL)
is a specification language for describing the initial state of a user
interface for a Motif application.  The specification describes the
objects (menus, dialog boxes, labels, push buttons, and so on) used
in the interface and specifies the routines to be called when the 
interface changes state as a result of user interaction.
.IP \fIfile\fR 10
Specifies the file to be compiled
through the UIL compiler. 
.IP \fIoptions\fR
Specifies one or more of the following options:
.RS
.IP "\-I\fIpathname\fP" 12
This option causes the compiler to look for include files
in the directory specified if the include files have not been 
found in the paths that already were searched.
Specify this option followed by a pathname, with no intervening 
spaces.
.br
.ne 8
.IP "\-m" 
Machine code is listed.  This directs the compiler to place in the
listing file a description of the
records that it added to the User Interface Database (UID).  This helps you isolate
errors.  The default is no machine code. 
.IP "\-o \fIfile\fP" 
.iX "user interface database"
.iX "uid file"
Directs the compiler to produce a UID.
By default, UIL creates a UID with the name \fBa.uid\fP.
The file specifies the filename for the UID.
No UID is produced if the compiler issues any diagnostics
categorized as error or severe.
.IP "\-v \fIfile\fP"
Directs the compiler to generate a listing.  
The file specifies the filename for the listing.
If the \fB\-v\fP option is not present,
no listing is generated by the compiler.
The default is no listing. 
.IP "\-w"
Specifies that the
compiler suppress all warning and informational messages.
If this option is not present, all messages are
generated,
regardless of the severity.
.RE
.PP
For more information about UIL syntax, see 
the \fIOSF/Motif Programmer's Guide\fP.
.SH "Related Information"
\fBX(1X)\fP, \fBUil(3X)\fP
