/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	resource.h,v $
 * Revision 2.1  89/08/04  14:48:07  rwd
 * Created.
 * 
 * Revision 2.5  88/10/11  12:08:31  rpd
 * 	Added include of time.h since this file uses 
 * 	struct timeval.
 * 	[88/10/11  11:41:22  rpd]
 * 
 * Revision 2.4  88/08/24  02:41:41  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:21:30  mwyoung]
 * 
 * Revision 2.3  88/08/22  21:29:44  mja
 * 	Add RUSAGE_NODEV definition.
 * 	[88/08/11  19:18:02  mja]
 * 
 * Revision 2.2  88/07/15  15:59:57  mja
 * Condensed local conditionals.
 * 
 * 06-Jan-88  Jay Kistler (jjk) at Carnegie Mellon University
 *	Made file reentrant.  Added declarations for __STDC__.
 *
 * 28-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS: Defined new rusage_dev structure for special
 *	wait3() option;
 *	CMUCS: Added RPAUSE definitions.
 *	[ V5.1(F1) ]
 *
 **********************************************************************
 */
 
#ifdef	KERNEL
#include <cmucs.h>
#else	KERNEL
#include <sys/features.h>
#endif	KERNEL
#include <sys/time.h>
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)resource.h	7.1 (Berkeley) 6/4/86
 */

#ifndef	_RESOURCE_
#define	_RESOURCE_	1

/*
 * Process priority specifications to get/setpriority.
 */
#define	PRIO_MIN	-20
#define	PRIO_MAX	20

#define	PRIO_PROCESS	0
#define	PRIO_PGRP	1
#define	PRIO_USER	2

/*
 * Resource utilization information.
 */

#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1

struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	long	ru_maxrss;
#define	ru_first	ru_ixrss
	long	ru_ixrss;		/* integral shared memory size */
	long	ru_idrss;		/* integral unshared data " */
	long	ru_isrss;		/* integral unshared stack " */
	long	ru_minflt;		/* page reclaims */
	long	ru_majflt;		/* page faults */
	long	ru_nswap;		/* swaps */
	long	ru_inblock;		/* block input operations */
	long	ru_oublock;		/* block output operations */
	long	ru_msgsnd;		/* messages sent */
	long	ru_msgrcv;		/* messages received */
	long	ru_nsignals;		/* signals received */
	long	ru_nvcsw;		/* voluntary context switches */
	long	ru_nivcsw;		/* involuntary " */
#define	ru_last		ru_nivcsw
};

/*
 * Resource limits
 */
#define	RLIMIT_CPU	0		/* cpu time in milliseconds */
#define	RLIMIT_FSIZE	1		/* maximum file size */
#define	RLIMIT_DATA	2		/* data size */
#define	RLIMIT_STACK	3		/* stack size */
#define	RLIMIT_CORE	4		/* core file size */
#define	RLIMIT_RSS	5		/* resident set size */

#define	RLIM_NLIMITS	6		/* number of resource limits */

#define	RLIM_INFINITY	0x7fffffff

struct rlimit {
	int	rlim_cur;		/* current (soft) limit */
	int	rlim_max;		/* maximum value for rlim_cur */
};
#if	CMUCS


#include <sys/types.h>

/*
 *  Special rusage structure returned with WLOGINDEV option to wait3().
 */

struct rusage_dev {
	struct rusage ru_rusage;
	dev_t	      ru_dev;
};

#define	RUSAGE_NODEV	((dev_t)-1)	/* same as NODEV */


/*
 *  Resource pause system call definitions
 */

#define	RPAUSE_SAME	0		/* leave state unchanged */
#define	RPAUSE_DISABLE	1		/* disable pause on error type(s) */
#define	RPAUSE_ENABLE	2		/* enable pause on error type(s) */

#define	RPAUSE_ALL	0x7fffffff	/* all error number types */
#endif	CMUCS

#if	defined(CMUCS) && defined(__STDC__) && !defined(KERNEL)
extern int getpriority(int, int);
extern int setpriority(int, int, int);
extern int getrlimit(int, struct rlimit *);
extern int setrlimit(int, struct rlimit *);
extern int getrusage(int, struct rusage *);
#endif	defined(CMUCS) && defined(__STDC__) && !defined(KERNEL)
#endif	_RESOURCE_
