.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_protect.man,v $
.\" Revision 2.5  91/05/14  17:16:04  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.4  91/02/14  14:16:26  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:17:28  mrt]
.\" 
.\" Revision 2.3  90/08/07  21:52:31  rpd
.\" 	Fixed the description of how protection enforcement
.\" 	is machine-dependent.
.\" 	[90/08/07            rpd]
.\" 
.\" Revision 2.2  90/08/07  18:47:51  rpd
.\" 	Created.
.\" 
.TH vm_protect 2 9/19/86
.CM 4
.SH NAME
.nf
vm_protect  \-  change protection of task's memory
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_protect(target_task, address, size, set_maximum,
				new_protection)
	vm_task_t	target_task;
	vm_address_t	address;
	vm_size_t	size;
	boolean_t	set_maximum;
	vm_prot_t	new_protection;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose virtual memory is to be affected.
.TP 15
.B
address
Starting address (will be rounded down to a
page boundary).
.TP 15
.B
size
Size in bytes of the region for which protection
is to change (will be rounded up to give a page boundary).
.TP 15
.B
set_maximum
If set, make the protection change apply to the 
maximum protection associated with this address range;
otherwise, the current protection on this
range is changed.  If the maximum protection is reduced below the
current protection, both will be changed to reflect the new maximum.
.TP 15
.B
new_protection
A new protection value for this region; a set of:
\fBVM_PROT_READ\fR, \fBVM_PROT_WRITE\fR, \fBVM_PROT_EXECUTE\fR.

.SH DESCRIPTION
.B vm_protect
sets the virtual memory access privileges for a
range of allocated addresses in a task's virtual address space.
The protection argument describes a combination of read, write,
and execute accesses that should be \fBpermitted\fR.

The enforcement of virtual memory protection is machine-dependent.
Nominally read access requires VM_PROT_READ permission, write access
requires VM_PROT_WRITE permission, and execute access requires
VM_PROT_EXECUTE permission.  However, some combinations of access
rights may not be supported.  In particular, the kernel interface
allows write access to require VM_PROT_READ and VM_PROT_WRITE
permission and execute access to require VM_PROT_READ permission.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory protected.
.TP 25
KERN_PROTECTION_FAILURE
An attempt was made to increase the current 
or maximum protection beyond the existing maximum protection value.
.TP 25
KERN_INVALID_ADDRESS
Illegal or non-allocated address specified.
