.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_suspend.man,v $
.\" Revision 2.4  91/05/14  17:14:48  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:45  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:16:36  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:46:45  rpd
.\" 	Created.
.\" 
.TH thread_suspend 2 1/22/88
.CM 4
.SH NAME
.nf
thread_suspend  \-  suspends specified thread
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_suspend(target_thread);
	thread_t	target_thread;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
The thread to be suspended.

.SH DESCRIPTION

Increments the thread's suspend count and prevents the thread
from executing any more user level instructions. In this context
a user level instruction is either a machine instruction executed
in user mode or a system trap instruction including page faults. 
Thus if a thread is currently executing within a system trap
the kernel code may continue to execute until it reaches the
system return code or it may supend within the kernel code. In either
case, when the thread is resumed the
system trap will return. This could cause unpredictible results if
the user did a suspend and then altered the user state of the thread
in order to change its direction upon a resume. The call 
.B thread_abort
is provided to allow the user to abort any system call that is in progress
in a predictable way.

The suspend count may become
greater than one with the effect that it will take more 
than one resume call to restart the thread.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The thread has been suspended.
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread.

.SH SEE ALSO
.B task_suspend, task_resume,
.B thread_info, thread_state,
.B thread_resume, thread_terminate, thread_abort

