.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	memory_object_terminate.man,v $
.\" Revision 2.4  91/05/14  17:10:40  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:13:33  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:14:18  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:41:48  rpd
.\" 	Created.
.\" 
.TH memory_object_terminate 2 12/19/89
.CM 4
.SH NAME
.nf
memory_object_terminate  \-  request to terminate memory object
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t memory_object_terminate(memory_object, memory_control,
			     memory_object_name)
	memory_object_t	memory_object;
                      memory_object_control_t 
			memory_control;
	               memory_object_name_t 
			memory_object_name;


.fi
.ft P
.SH DESCRIPTION
.B memory_object_terminate
indicates that the has completed its use of the given memory object.  All rights to the
memory object control and name ports are included, so that the
memory manager can destroy them (using 
.B port_deallocate
)
after doing appropriate bookkeeping.  The kernel will terminate a memory
object only after all address space mappings of that memory object have
been deallocated, or upon explicit request by the memory manager.

.SH ARGUMENTS
.TP 15
.B
.B memory_object
The port that represents the memory object data, as 
supplied to the kernel in a 
.B vm_map
call.
.TP 15
.B
.B memory_control
The request port to which a response is 
requested.  [In the event that a memory object has been supplied 
to more than one the kernel that has made the request.]
.TP 15
.B
.B memory_object_name
A port used by the kernel to refer to the 
memory object data in reponse to 
.B vm_region
calls.

.SH DIAGNOSTICS
.TP 25
.B KERN_SUCCESS
Since this routine is called by the kernel, which does not
wait for a reply message, this value is ignored.

.SH SEE ALSO
.B memory_object_destroy, port_deallocate

