.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_request_notification.man,v $
.\" Revision 2.5  91/12/11  08:43:16  jsb
.\" 	Changed <mach/mach.h> to <mach.h>.
.\" 	[91/11/25  10:55:53  rpd]
.\" 
.\" Revision 2.4  91/05/14  17:07:28  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:11:53  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:12:05  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:38:04  rpd
.\" 	Created.
.\" 
.TH mach_port_request_notification 2 4/13/87
.CM 4
.SH NAME
.nf
mach_port_request_notification \- request a notification
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

kern_return_t
mach_port_request_notification(task, name, variant, sync,
			       notify, notify_type, previous)
	task_t task;
	mach_port_t name;
	mach_msg_id_t variant;
	mach_port_mscount_t sync;
	mach_port_t notify;
	mach_msg_type_name_t notify_type;
	mach_port_t *previous;		/* out */
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task holding the specified right.
.TP 12
.B
name
The task's name for the right.
.TP 12
.B
variant
The type of notification.
.TP 12
.B
sync
Some variants use this value to overcome race conditions.
.TP 12
.B
notify
A send-once right, to which the notification will be sent.
.TP 12
.B
notify_type
IPC type of the sent right; either MACH_MSG_TYPE_MAKE_SEND_ONCE
or MACH_MSG_TYPE_MOVE_SEND_ONCE.
.TP 12
.B
previous
The previously registered send-once right.
.SH DESCRIPTION
\fBmach_port_request_notification\fR
registers a request for a notification and supplies a send-once right
that the notification will use.  It is an atomic swap, returning
the previously registered send-once right (or MACH_PORT_NULL for none).
A previous notification request may be cancelled by providing MACH_PORT_NULL
for \fBnotify\fR.

The \fBvariant\fR argument takes the following values:
.TP 12
MACH_NOTIFY_PORT_DESTROYED
\fBsync\fR must be
zero.  The \fBname\fR must specify a receive right, and the call
requests a port-destroyed notification for the receive right.  If the
receive right were to have been destroyed, say by
\fBmach_port_destroy\fR, then instead the receive right will be sent
in a port-destroyed notification to the registered send-once right.
.TP 12
MACH_NOTIFY_DEAD_NAME
The call requests
a dead-name notification.  \fBname\fR specifies send, receive, or
send-once rights for a port.  If the port is destroyed (and the right
remains, becoming a dead name), then a dead-name
notification which carries the name of the right will be sent
to the registered send-once right.  If \fBnotify\fR is not null
and \fBsync\fR is non-zero,
the \fBname\fR may specify a dead name, and a dead-name notification
is immediately generated.

Whenever a dead-name notification is generated, the user reference
count of the dead name is incremented.  For example, a send right
with two user refs has a registered dead-name request.  If the port
is destroyed, the send right turns into a dead name with three user
refs (instead of two), and a dead-name notification is generated.

If the name is made available for reuse, perhaps because of
\fBmach_port_destroy\fR or \fBmach_port_mod_refs\fR, or the name
denotes a send-once right which has a message sent to it,
then the registered send-once right is
used to generate a port-deleted notification.
.TP 12
MACH_NOTIFY_NO_SENDERS
The call requests
a no-senders notification.  \fBname\fR must specify a receive right.
If \fBnotify\fR is not null,
and the receive right's make-send count is greater than or equal to
the sync value,
and it has no extant send rights, than an immediate no-senders
notification is generated.  Otherwise the notification is generated
when the receive right next loses its last extant send right.
In either case, any previously registered send-once right is returned.

The no-senders notification carries the value the port's make-send
count had when it was generated.  The make-send count is incremented
whenever MACH_MSG_TYPE_MAKE_SEND is used to create a new send right
from the receive right.  The make-send count is reset to zero
when the receive right is carried in a message.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_VALUE
\fBvariant\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBname\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBname\fR denoted an invalid right.
.TP 25
KERN_INVALID_CAPABILITY
\fBnotify\fR was invalid.
.PP
When using MACH_NOTIFY_PORT_DESTROYED:
.TP 25
KERN_INVALID_VALUE
\fBsync\fR was not zero.
.PP
When using MACH_NOTIFY_DEAD_NAME:
.TP 25
KERN_RESOURCE_SHORTAGE
The kernel ran out of memory.
.TP 25
KERN_INVALID_ARGUMENT
\fBname\fR denotes a dead name, but \fBsync\fR is zero
or \fBnotify\fR is null.
.TP 25
KERN_UREFS_OVERFLOW
\fBname\fR denotes a dead name, but generating an immediate
dead-name notification would overflow the name's user-reference count.
.PP
The \fBmach_port_request_notification\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_get_receive_status(2).
