.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)wait.2	6.2 (Berkeley) 6/30/85
.\"
.TH WAIT 2 "June 30, 1985"
.UC 4
.SH NAME
wait, wait3 \- wait for process to terminate
.SH SYNOPSIS
.ft B
.nf
#include <sys/wait.h>
.PP
.ft B
pid = wait(status)
int pid;
union wait *status;
.PP
.ft B
pid = wait(0)
int pid;
.PP
.ft B
#include <sys/time.h>
#include <sys/resource.h>
.PP
.ft B
pid = wait3(status, options, rusage)
int pid;
union wait *status;
int options;
struct rusage *rusage;
.fi
.SH DESCRIPTION
.I Wait
causes its caller to delay until a signal is received or
one of its child
processes terminates.
If any child has died since the last
.IR wait ,
return is immediate, returning the process id and
exit status of one of the terminated
children.
If there are no children, return is immediate with
the value \-1 returned.
.PP
On return from a successful 
.I wait
call, 
.I status
is nonzero, and the high byte of 
.I status
contains the low byte of the argument to
.I exit
supplied by the child process;
the low byte of 
.I status
contains the termination status of the process.
A more precise definition of the
.I status
word is given in
.RI < sys/wait.h >.
.PP
.I Wait3
provides an alternate interface for programs
that must not block when collecting the status
of child processes.  The
.I status
parameter is defined as above.  The
.I options
parameter is used to indicate the call should not block if
there are no processes that wish to report status (WNOHANG),
and/or that children of the current process that are stopped
due to a SIGTTIN, SIGTTOU, SIGTSTP, or SIGSTOP signal should also have
their status reported (WUNTRACED).  If
.I rusage
is non-zero, a summary of the resources used by the terminated
process and all its
children is returned (this information is currently not available
for stopped processes).
.PP
When the WNOHANG option is specified and no processes
wish to report status, 
.I wait3
returns a 
.I pid
of 0.  The WNOHANG and WUNTRACED options may be combined by 
.IR or 'ing
the two values.
.SH NOTES
See
.IR sigvec (2)
for a list of termination statuses (signals);
0 status indicates normal termination.
A special status (0177) is returned for a stopped process
that has not terminated and can be restarted;
see
.IR ptrace (2).
If the 0200 bit of the termination status
is set,
a core image of the process was produced
by the system.
.PP
If the parent process terminates without
waiting on its children,
the initialization process
(process ID = 1)
inherits the children.
.PP
.I Wait
and
.I wait3
are automatically restarted when a process receives a
signal while awaiting termination of a child process.
.SH "RETURN VALUE
If \fIwait\fP returns due to a stopped
or terminated child process, the process ID of the child
is returned to the calling process.  Otherwise, a value of \-1
is returned and \fIerrno\fP is set to indicate the error.
.PP
.I Wait3
returns \-1 if there are no children not previously waited
for;  0 is returned if WNOHANG is specified and there are
no stopped or exited children.
.SH ERRORS
.I Wait
will fail and return immediately if one or more of the following
are true:
.TP 15
[ECHILD]
The calling process has no existing unwaited-for
child processes.
.TP 15
[EFAULT]
The \fIstatus\fP or \fIrusage\fP arguments point to an illegal address.
.SH "SEE ALSO"
exit(2)
