.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)utimes.2	6.5 (Berkeley) 9/30/87
.\"
.TH UTIMES 2 "September 30, 1987"
.UC 4
.SH NAME
utimes \- set file times
.SH SYNOPSIS
.nf
.ft B
#include <sys/time.h>
.PP
.ft B
utimes(file, tvp)
char *file;
struct timeval tvp[2];
.fi
.SH DESCRIPTION
The
.I utimes
call
uses the
\*(lqaccessed\*(rq and \*(lqupdated\*(rq times in that order
from the
.I tvp
vector
to set the corresponding recorded times for
.I file.
.PP
The caller must be the owner of the file or the super-user.
The \*(lqinode-changed\*(rq time of the file is set to the current time.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.
Otherwise, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH "ERRORS
.I Utimes
will fail if one or more of the following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The process is not super-user and not the owner of the file.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EROFS]
The file system containing the file is mounted read-only.
.TP 15
[EFAULT]
.I File
or \fItvp\fP points outside the process's allocated address space.
.TP 15
[EIO]
An I/O error occurred while reading or writing the affected inode.
.SH SEE ALSO
stat(2)
