.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)unlink.2	6.2 (Berkeley) 5/22/85
.\"
.TH UNLINK 2 "May 22, 1985"
.UC 4
.SH NAME
unlink \- remove directory entry
.SH SYNOPSIS
.nf
.ft B
unlink(path)
char *path;
.fi
.ft R
.SH DESCRIPTION
.I Unlink
removes the entry for the file
.I path
from its directory.
If this entry was the last link to the file,
and no process has the file open, then
all resources associated with the file are reclaimed.
If, however, the file was open in any process, the actual
resource reclamation is delayed until it is closed,
even though the directory entry has disappeared.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.
Otherwise, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH "ERRORS
The \fIunlink\fP succeeds unless:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EACCES]
Write permission is denied on the directory containing the link
to be removed.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The named file is a directory and the effective user ID
of the process is not the super-user.
.TP 15
[EPERM]
The directory containing the file is marked sticky,
and neither the containing directory nor the file to be removed
are owned by the effective user ID.
.TP 15
[EBUSY]
The entry to be unlinked is the mount point for a
mounted file system.
.TP 15
[EIO]
An I/O error occurred while deleting the directory entry
or deallocating the inode.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.SH "SEE ALSO"
close(2), link(2), rmdir(2)
