.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)swapon.2	6.4 (Berkeley) 3/9/86
.\"
.TH SWAPON 2 "March 9, 1986"
.UC 4
.SH NAME
swapon \- add a swap device for interleaved paging/swapping
.SH SYNOPSIS
.nf
.B swapon(special)
.B char *special;
.fi
.SH DESCRIPTION
.I Swapon
makes the block device 
.I special 
available to the system for
allocation for paging and swapping.  The names of potentially
available devices are known to the system and defined at system
configuration time.  The size of the swap area on 
.I special 
is calculated at the time the device is first made available
for swapping.
.SH "RETURN VALUE
If an error has occurred, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH ERRORS
.I Swapon
succeeds unless:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named device does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[ENOTBLK]
.I Special
is not a block device.
.TP 15
[EBUSY]
The device specified by \fIspecial\fP has already
been made available for swapping
.TP 15
[EINVAL]
The device configured by \fIspecial\fP was not
configured into the system as a swap device.
.TP 15
[ENXIO]
The major device number of 
.I special
is out of range (this indicates no device driver exists
for the associated hardware).
.TP 15
[EIO]
An I/O error occurred while opening the swap device.
.TP 15
[EFAULT]
.I Special
points outside the process's allocated address space.
.SH "SEE ALSO"
swapon(8), config(8)
.SH BUGS
There is no way to stop swapping on a disk so that the pack may be
dismounted.
.PP
This call will be upgraded in future versions of the system.
