.\"
.\" $Id: statfs.2,v 2.2 89/12/27 13:00:59 bww Exp $
.\"
.\" HISTORY
.\" $Log:	statfs.2,v $
.\" Revision 2.2  89/12/27  13:00:59  bww
.\" 	Sun Microsystems Rel 3.0
.\" 	[89/12/27  12:59:57  bww]
.\" 
.\"
.\" @(#)statfs.2 1.1 85/12/28 SMI;
.\"
.TH STATFS 2 "19 August 1985"
.SU
.SH NAME
statfs \- get file system statistics
.SH SYNOPSIS
.nf
.ft B
#include <sys/vfs.h>
.sp.5
statfs(path, buf)
char *path;
struct statfs *buf;
.sp.5
fstatfs(fd, buf)
int fd;
struct statfs *buf;
.fi
.SH DESCRIPTION
.I Statfs
returns information about a mounted file system.
.I Path
is the pathname of any file within the mounted filesystem.
.I Buf
is a pointer to a
.I statfs
structure defined as follows:
.IP
.ta \w'#define'u +\w'fsid_t\0\0'u +\w'f_spare[7]\0\0'u
.nf
typedef struct {
	long	val[2];
} fsid_t;
.sp.5
struct statfs {
	long	f_type; 	/* type of info, zero for now */
	long	f_bsize;	/* fundamental file system block size */
	long	f_blocks;	/* total blocks in file system */
	long	f_bfree;	/* free blocks */
	long	f_bavail;	/* free blocks available to non-superuser */
	long	f_files;	/* total file nodes in file system */
	long	f_ffree;	/* free file nodes in fs */
	fsid_t	f_fsid; 	/* file system id */
	long	f_spare[7];	/* spare for later */
};
.fi
.LP
Fields that are undefined for a particular file system are set to \-1.
.I Fstatfs
returns the same information about an open file referenced by descriptor
.IR fd .
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.
Otherwise, \-1 is returned and the global variable
.I errno
is set to indicate the error.
.SH "ERRORS
.I Statfs
fails if one or more of the following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EPERM]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
The pathname was too long.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EFAULT]
.I Buf
or
.I name
points to an invalid address.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.LP
.I Fstatfs
fails if one or both of the following are true:
.TP 15
[EBADF]
.I Fildes
is not a valid open file descriptor.
.TP 15
[EFAULT]
.I Buf
points to an invalid address.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
