.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)stat.2	6.7 (Berkeley) 10/25/87
.\"
.TH STAT 2 "October 25, 1987"
.UC 4
.SH NAME
stat, lstat, fstat \- get file status
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
#include <sys/stat.h>
.PP
.ft B
stat(path, buf)
char *path;
struct stat *buf;
.PP
.ft B
lstat(path, buf)
char *path;
struct stat *buf;
.PP
.ft B
fstat(fd, buf)
int fd;
struct stat *buf;
.fi
.ft R
.SH DESCRIPTION
.I Stat
obtains information about the file
.IR path .
Read, write or execute
permission of the named file is not required, but all directories
listed in the path name leading to the file must be reachable.
.PP
.I Lstat
is like \fIstat\fP except in the case where the named file is a symbolic link,
in which case
.I lstat
returns information about the link,
while
.I stat
returns information about the file the link references.
.PP
.I Fstat
obtains the same information about an open file
referenced by the argument descriptor, such as would
be obtained by an \fIopen\fP call.
.PP
.I Buf
is a pointer to a
.I stat
structure into which information is placed concerning the file.
The contents of the structure pointed to by
.I buf
.PP
.nf
.ta 1i 1.7i 2.5i
     struct stat {
	dev_t	st_dev;	/* device inode resides on */
	ino_t	st_ino;	/* this inode's number */
	u_short	st_mode;	/* protection */
	short	st_nlink;	/* number or hard links to the file */
	uid_t	st_uid;	/* user-id of owner */
	gid_t	st_gid;	/* group-id of owner */
	dev_t	st_rdev;	/* the device type, for inode that is device */
	off_t	st_size;	/* total size of file */
	time_t	st_atime;	/* file last access time */
	int	st_spare1;
	time_t	st_mtime;	/* file last modify time */
	int	st_spare2;
	time_t	st_ctime;	/* file last status change time */
	int	st_spare3;
	long	st_blksize;	/* optimal blocksize for file system i/o ops */
	long	st_blocks;	/* actual number of blocks allocated */
	long	st_spare4[2];
    };
.fi
.DT
.PP
.TP 12
st_atime
Time when file data was last accessed.  Changed by the following system
calls:
.IR mknod (2),
.IR utimes (2),
and
.IR read (2).
For reasons of efficiency, 
st_atime is not set when a directory
is searched, although this would be more logical.
.TP 12
st_mtime
Time when data was last modified.
It is not set by changes of owner, group, link count, or mode.
Changed by the following system calls:
.IR mknod (2),
.IR utimes (2),
.IR write (2).
.TP 12
st_ctime
Time when file status was last changed.
It is set both both by writing and changing the i-node.
Changed by the following system calls:
.IR chmod (2)
.IR chown (2),
.IR link (2),
.IR mknod (2),
.IR rename (2),
.IR unlink (2),
.IR utimes (2),
.IR write (2).
.PP
The status information word \fIst_mode\fP has bits:
.nf
.in +5n
.ta 1.6i 2.5i 3i
#define S_IFMT	0170000	/* type of file */
#define\ \ \ \ S_IFDIR	0040000	/* directory */
#define\ \ \ \ S_IFCHR	0020000	/* character special */
#define\ \ \ \ S_IFBLK	0060000	/* block special */
#define\ \ \ \ S_IFREG	0100000	/* regular */
#define\ \ \ \ S_IFLNK	0120000	/* symbolic link */
#define\ \ \ \ S_IFSOCK	0140000	/* socket */
#define S_ISUID	0004000	/* set user id on execution */
#define S_ISGID	0002000	/* set group id on execution */
#define S_ISVTX	0001000	/* save swapped text even after use */
#define S_IREAD	0000400	/* read permission, owner */
#define S_IWRITE	0000200	/* write permission, owner */
#define S_IEXEC	0000100	/* execute/search permission, owner */
.fi
.in -5n
.PP
The mode bits 0000070 and 0000007 encode group and
others permissions (see
.IR chmod (2)).
.SH "RETURN VALUE
Upon successful completion a value of 0 is returned.
Otherwise, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH "ERRORS
.I Stat
and
.I lstat
will fail if one or more of the following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EFAULT]
.I Buf
or
.I name
points to an invalid address.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.PP
.I Fstat
will fail if one or both of the following are true:
.TP 15
[EBADF]
.I Fildes
is not a valid open file descriptor.
.TP 15
[EFAULT]
.I Buf
points to an invalid address.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.SH CAVEAT
The fields in the stat structure currently marked 
.IR st_spare1 ,
.IR st_spare2 ,
and
.I st_spare3
are present in preparation for inode time stamps expanding
to 64 bits.  This, however, can break certain programs that
depend on the time stamps being contiguous (in calls to
.IR utimes (2)).
.SH "SEE ALSO"
chmod(2), chown(2), utimes(2)
.SH BUGS
Applying
.I fstat
to a socket (and thus to a pipe)
returns a zero'd buffer,
except for the blocksize field,
and a unique device and inode number.
