.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)socketpair.2	6.1 (Berkeley) 5/15/85
.\"
.TH SOCKETPAIR 2 "May 15, 1985"
.UC 5
.SH NAME
socketpair \- create a pair of connected sockets
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
#include <sys/socket.h>
.PP
.ft B
socketpair(d, type, protocol, sv)
int d, type, protocol;
int sv[2];
.fi
.SH DESCRIPTION
The
.I socketpair
call creates an unnamed pair of connected sockets in
the specified domain
.IR d ,
of the specified
.IR type ,
and using the optionally specified
.IR protocol .
The descriptors used in referencing the new sockets
are returned in
.IR sv [0]
and
.IR sv [1].
The two sockets are indistinguishable.
.SH DIAGNOSTICS
A 0 is returned if the call succeeds, \-1 if it fails.
.SH ERRORS
The call succeeds unless:
.TP 20
[EMFILE]
Too many descriptors are in use by this process.
.TP 20
[EAFNOSUPPORT]
The specified address family is not supported on this machine.
.TP 20
[EPROTONOSUPPORT]
The specified protocol is not supported on this machine.
.TP 20
[EOPNOSUPPORT]
The specified protocol does not support creation of socket pairs.
.TP 20
[EFAULT]
The address \fIsv\fP does not specify a valid part of the
process address space.
.SH "SEE ALSO"
read(2), write(2), pipe(2)
.SH BUGS
This call is currently implemented only for the UNIX domain.
