.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sigsetmask.2	6.3 (Berkeley) 5/14/86
.\"
.TH SIGSETMASK 2 "May 14, 1986"
.UC 5
.SH NAME
sigsetmask \- set current signal mask
.SH SYNOPSIS
.nf
.B #include <signal.h>

.B sigsetmask(mask);
.B int mask;

.B mask = sigmask(signum)
.SH DESCRIPTION
.I Sigsetmask
sets the current signal mask (those signals
that are blocked from delivery).
Signals are blocked if the
corresponding bit in 
.I mask
is a 1; the macro
.I sigmask
is provided to construct the mask for a given
.IR signum .
.PP
The system
quietly disallows SIGKILL, SIGSTOP, or SIGCONT to
be blocked.
.SH "RETURN VALUE
The previous set of masked signals is returned.
.SH "SEE ALSO"
kill(2), sigvec(2), sigblock(2), sigpause(2)
