.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sigpause.2	6.2 (Berkeley) 5/15/86
.\"
.TH SIGPAUSE 2 "May 15, 1986"
.UC 4
.SH NAME
sigpause \- atomically release blocked signals and wait for interrupt
.SH SYNOPSIS
.ft B
sigpause(sigmask)
.br
int sigmask;
.ft R
.SH DESCRIPTION
.I Sigpause
assigns 
.I sigmask
to the set of masked signals
and then waits for a signal to arrive;
on return the set of masked signals is restored.
.I Sigmask
is usually 0 to indicate that no
signals are now to be blocked.
.I Sigpause
always terminates by being interrupted, returning \-1 with
.I errno
set to EINTR.
.PP
In normal usage, a signal is blocked using
.IR sigblock (2),
to begin a critical section, variables modified on the occurrence
of the signal are examined to determine that there is no work
to be done, and the process pauses awaiting work by using
.I sigpause
with the mask returned by
.IR sigblock .
.SH SEE ALSO
sigblock(2), sigvec(2)
