.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sigblock.2	6.3 (Berkeley) 5/14/86
.\"
.TH SIGBLOCK 2 "May 14, 1986"
.UC 5
.SH NAME
sigblock \- block signals
.SH SYNOPSIS
.nf
.B #include <signal.h>

.B sigblock(mask);
.B int mask;

.B mask = sigmask(signum)
.SH DESCRIPTION
.I Sigblock
causes the signals specified in
.I mask
to be added to the set of signals currently
being blocked from delivery.
Signals are blocked if the
corresponding bit in 
.I mask
is a 1; the macro
.I sigmask
is provided to construct the mask for a given
.IR signum .
.PP
It is not possible to block SIGKILL,
SIGSTOP, or SIGCONT;  this restriction is silently
imposed by the system.
.SH "RETURN VALUE
The previous set of masked signals is returned.
.SH "SEE ALSO"
kill(2), sigvec(2), sigsetmask(2)
