.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)setregid.2	6.1 (Berkeley) 5/15/85
.\"
.TH SETREGID 2 "May 15, 1985"
.UC 5
.SH NAME
setregid \- set real and effective group ID
.SH SYNOPSIS
.ft B
setregid(rgid, egid)
.br
int rgid, egid;
.ft R
.SH DESCRIPTION
The real and effective group ID's of the current process
are set to the arguments.
Unprivileged users may change the real group
ID to the effective group ID and vice-versa; only the super-user may
make other changes.
.PP
Supplying a value of \-1 for either the real or effective
group ID forces the system to substitute the current
ID in place of the \-1 parameter.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.  Otherwise,
a value of \-1 is returned and \fIerrno\fP is set to indicate the error.
.SH "ERRORS
.TP 15
[EPERM]
The current process is not the super-user and a change
other than changing the effective group-id to the real group-id
was specified.
.SH "SEE ALSO"
getgid(2), setreuid(2), setgid(3)
