.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)setgroups.2	6.4 (Berkeley) 4/10/87
.\"
.TH SETGROUPS 2 "April 10, 1987"
.UC 5
.SH NAME
setgroups \- set group access list
.SH SYNOPSIS
.nf
.ft B
#include <sys/param.h>
.PP
.ft B
setgroups(ngroups, gidset)
int ngroups, *gidset;
.fi
.SH DESCRIPTION
.I Setgroups
sets the group access list of the current user process
according to the array 
.IR gidset .
The parameter
.I ngroups
indicates the number of entries in the array and must be no
more than NGROUPS, as defined in
.RI < sys/param.h >.
.PP
Only the super-user may set new groups.
.SH "RETURN VALUE
A 0 value is returned on success, \-1 on error, with
a error code stored in \fIerrno\fP.
.SH "ERRORS
The \fIsetgroups\fP call will fail if:
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[EFAULT]
The address specified for \fIgidset\fP is outside the process
address space.
.SH "SEE ALSO
getgroups(2), initgroups(3)
.SH BUGS
The
.I gidset
array should be of type
.BR gid_t ,
but remains integer for compatibility with earlier systems.
