.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)select.2	6.5 (Berkeley) 5/15/86
.\"
.TH SELECT 2 "May 15, 1986"
.UC 5
.SH NAME
select \- synchronous I/O multiplexing
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
#include <sys/time.h>
.PP
.ft B
nfound = select(nfds, readfds, writefds, exceptfds, timeout)
int nfound, nfds;
fd_set *readfds, *writefds, *exceptfds;
struct timeval *timeout;
.PP
.ft B
FD_SET(fd, &fdset)	
FD_CLR(fd, &fdset)	
FD_ISSET(fd, &fdset)	
FD_ZERO(&fdset)	
int fd;
fd_set fdset;
.fi
.SH DESCRIPTION
.I Select
examines the I/O descriptor sets whose addresses are passed in
.IR readfds ,
.IR writefds ,
and
.I exceptfds
to see if some of their descriptors
are ready for reading, are ready for writing, or have an exceptional
condition pending, respectively.
The first
.I nfds
descriptors are checked in each set;
i.e. the descriptors from 0 through
.IR nfds -1
in the descriptor sets are examined.
On return,
.I select
replaces the given descriptor sets
with subsets consisting of those descriptors that are ready
for the requested operation.
The total number of ready descriptors in all the sets is returned in
.IR nfound .
.PP
The descriptor sets are stored as bit fields in arrays of integers.
The following macros are provided for manipulating such descriptor sets:
.I "FD_ZERO(&fdset)"
initializes a descriptor set
.I fdset
to the null set.
.I "FD_SET(fd, &fdset)"
includes a particular descriptor
.I fd
in
.IR fdset .
.I "FD_CLR(fd, &fdset)"
removes
.I fd
from
.IR fdset .
.I "FD_ISSET(fd, &fdset)"
is nonzero if
.I fd
is a member of
.IR fdset ,
zero otherwise.
The behavior of these macros is undefined if
a descriptor value is less than zero or greater than or equal to
.IR FD_SETSIZE ,
which is normally at least equal
to the maximum number of descriptors supported by the system.
.PP
If
.I timeout
is a non-zero pointer, it specifies a maximum interval to wait for the
selection to complete.  If 
.I timeout
is a zero pointer, the select blocks indefinitely.  To affect a poll, the
.I timeout
argument should be non-zero, pointing to a zero-valued timeval structure.
.PP
Any of
.IR readfds ,
.IR writefds ,
and
.I exceptfds
may be given as zero pointers if no descriptors are of interest.
.SH "RETURN VALUE
.I Select
returns the number of ready descriptors that are contained in
the descriptor sets,
or \-1 if an error occurred.
If the time limit expires then
.I select
returns 0.
If
.I select
returns with an error,
including one due to an interrupted call,
the descriptor sets will be unmodified.
.SH "ERRORS
An error return from \fIselect\fP indicates:
.TP 15
[EBADF]
One of the descriptor sets specified an invalid descriptor.
.TP 15
[EINTR]
A signal was delivered before the time limit expired and
before any of the selected events occurred.
.TP 15
[EINVAL]
The specified time limit is invalid.  One of its components is
negative or too large.
.SH SEE ALSO
accept(2), connect(2), read(2), write(2), recv(2), send(2), getdtablesize(2)
.SH BUGS
Although the provision of
.IR getdtablesize (2)
was intended to allow user programs to be written independent
of the kernel limit on the number of open files, the dimension
of a sufficiently large bit field for select remains a problem.
The default size FD_SETSIZE (currently 256) is somewhat larger than
the current kernel limit to the number of open files.
However, in order to accommodate programs which might potentially
use a larger number of open files with select, it is possible
to increase this size within a program by providing
a larger definition of FD_SETSIZE before the inclusion of <sys/types.h>.
.PP
.I Select
should probably return the time remaining from the original timeout,
if any, by modifying the time value in place.
This may be implemented in future versions of the system.
Thus, it is unwise to assume that the timeout value will be unmodified
by the
.I select
call.
