.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)recv.2	6.5 (Berkeley) 7/21/87
.\"
.TH RECV 2 "July 21, 1987"
.UC 5
.SH NAME
recv, recvfrom, recvmsg \- receive a message from a socket
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
#include <sys/socket.h>
.PP
.ft B
cc = recv(s, buf, len, flags)
int cc, s;
char *buf;
int len, flags;
.PP
.ft B
cc = recvfrom(s, buf, len, flags, from, fromlen)
int cc, s;
char *buf;
int len, flags;
struct sockaddr *from;
int *fromlen;
.PP
.ft B
cc = recvmsg(s, msg, flags)
int cc, s;
struct msghdr *msg;
int flags;
.ft R
.SH DESCRIPTION
.IR Recv ,
.IR recvfrom ,
and
.IR recvmsg
are used to receive messages from a socket.
.PP
The 
.I recv
call is normally used only on a 
.I connected
socket (see
.IR connect (2)),
while 
.I recvfrom
and 
.I recvmsg
may be used to receive data on a socket whether
it is in a connected state or not.
.PP
If
.I from
is non-zero, the source address of the message is filled in.
.I Fromlen
is a value-result parameter, initialized to the size of
the buffer associated with
.IR from ,
and modified on return to indicate the actual size of the
address stored there.
The length of the message is returned in
.IR cc .
If a message is too long to fit in the supplied buffer,
excess bytes may be discarded depending on the type of socket
the message is received from (see
.IR socket (2)).
.PP
If no messages are available at the socket, the
receive call waits for a message to arrive, unless
the socket is nonblocking (see
.IR ioctl (2))
in which case a
.I cc
of \-1 is returned with the external variable errno
set to EWOULDBLOCK.
.PP
The
.IR select (2)
call may be used to determine when more data arrives.
.PP
The
.I flags
argument to a recv call is formed by 
.IR or 'ing
one or more of the values,
.PP
.nf
.RS
.ta \w'#define\ \ 'u +\w'MSG_DONTROUTE\ \ \ 'u +\w'0x\0\0\0\ \ 'u
#define	MSG_OOB	0x1	/* process out-of-band data */
#define	MSG_PEEK	0x2	/* peek at incoming message */
.RE
.fi
.PP
The
.I recvmsg
call uses a 
.I msghdr
structure to minimize the number of directly supplied parameters.
This structure has the following form, as defined in
.IR <sys/socket.h> :
.PP
.nf
.RS
.DT
struct msghdr {
	caddr_t	msg_name;		/* optional address */
	int	msg_namelen;		/* size of address */
	struct	iovec *msg_iov;		/* scatter/gather array */
	int	msg_iovlen;		/* # elements in msg_iov */
	caddr_t	msg_accrights;		/* access rights sent/received */
	int	msg_accrightslen;
};
.RE
.fi
.PP
Here
.I msg_name
and
.I msg_namelen
specify the destination address if the socket is unconnected;
.I msg_name
may be given as a null pointer if no names are desired or required.
The 
.I msg_iov
and
.I msg_iovlen
describe the scatter gather locations, as described in
.IR read (2).
A buffer to receive any access rights sent along with the message is specified
in 
.IR msg_accrights ,
which has length
.IR msg_accrightslen .
Access rights are currently limited to file descriptors,
which each occupy the size of an
.BR int .
If access rights are not being transferred, the 
.I msg_accrights
field should be set to NULL.
.SH "RETURN VALUE
These calls return the number of bytes received, or \-1
if an error occurred.
.SH ERRORS
The calls fail if:
.TP 20
[EBADF]
The argument \fIs\fP is an invalid descriptor.
.TP 20
[ENOTSOCK]
The argument \fIs\fP is not a socket.
.TP 20
[EWOULDBLOCK]
The socket is marked non-blocking and the receive operation
would block.
.TP 20
[EINTR]
The receive was interrupted by delivery of a signal before
any data was available for the receive.
.TP 20
[EFAULT]
The data was specified to be received into a non-existent
or protected part of the process address space.
.SH SEE ALSO
fcntl(2), read(2), send(2), select(2), getsockopt(2), socket(2)
