.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)open.2	6.4 (Berkeley) 5/14/86
.\"
.TH OPEN 2 "May 14, 1986"
.UC 4
.SH NAME
open \- open a file for reading or writing, or create a new file
.SH SYNOPSIS
.nf
.ft B
#include <sys/file.h>
.PP
.ft B
open(path, flags, mode)
char *path;
int flags, mode;
.fi
.SH DESCRIPTION
.I Open
opens the file
.I path
for reading and/or writing, as specified by the
.I flags
argument and returns a descriptor for that file.
The
.I flags
argument may indicate the file is to be
created if it does not already exist (by specifying the
O_CREAT flag), in which case the file is created with mode
.I mode
as described in
.IR chmod (2)
and modified by the process' umask value (see
.IR umask (2)).
.PP
.I Path
is the address of a string of ASCII characters representing
a path name, terminated by a null character.
The flags specified are formed by
.IR or 'ing
the following values
.PP
.RS
 O_RDONLY	open for reading only
 O_WRONLY	open for writing only
 O_RDWR	open for reading and writing
 O_NDELAY	do not block on open
 O_APPEND	append on each write
 O_CREAT	create file if it does not exist
 O_TRUNC	truncate size to 0
 O_EXCL	error if create and file exists
.RE
.PP
Opening a file with O_APPEND set causes each write on the file
to be appended to the end.  If O_TRUNC is specified and the
file exists, the file is truncated to zero length.
If O_EXCL is set with O_CREAT, then if the file already
exists, the open returns an error.  This can be used to
implement a simple exclusive access locking mechanism.
If O_EXCL is set and the last component of the pathname is
a symbolic link, the open will fail even if the symbolic
link points to a non-existent name.
If the O_NDELAY flag is specified and the open call would result
in the process being blocked for some reason (e.g. waiting for
carrier on a dialup line), the open returns immediately. 
The first time the process attempts to perform i/o on the open
file it will block (not currently implemented).
.PP
Upon successful completion a non-negative integer termed a
file descriptor is returned.
The file pointer used to mark the current position within the
file is set to the beginning of the file.
.PP
The new descriptor is set to remain open across
.IR execve
system calls; see
.IR close (2).
.PP
The system imposes a limit on the number of file descriptors
open simultaneously by one process.
.IR Getdtablesize (2)
returns the current system limit.
.SH "ERRORS
The named file is opened unless one or more of the
following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
O_CREAT is not set and the named file does not exist.
.TP 15
[ENOENT]
A component of the path name that must exist does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EACCES]
The required permissions (for reading and/or writing)
are denied for the named flag.
.TP 15
[EACCES]
O_CREAT is specified,
the file does not exist,
and the directory in which it is to be created
does not permit writing.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EISDIR]
The named file is a directory, and the arguments specify
it is to be opened for writting.
.TP 15
[EROFS]
The named file resides on a read-only file system,
and the file is to be modified.
.TP 15
[EMFILE]
The system limit for open file descriptors per process has already been reached.
.TP 15
[ENFILE]
The system file table is full.
.TP 15
[ENXIO]
The named file is a character special or block
special file, and the device associated with this special file
does not exist.
.TP 15
[ENOSPC]
O_CREAT is specified,
the file does not exist,
and the directory in which the entry for the new file is being placed
cannot be extended because there is no space left on the file
system containing the directory.
.TP 15
[ENOSPC]
O_CREAT is specified,
the file does not exist,
and there are no free inodes on the file system on which the
file is being created.
.TP 15
[EDQUOT]
O_CREAT is specified,
the file does not exist,
and the directory in which the entry for the new fie
is being placed cannot be extended because the
user's quota of disk blocks on the file system
containing the directory has been exhausted.
.TP 15
[EDQUOT]
O_CREAT is specified,
the file does not exist,
and the user's quota of inodes on the file system on
which the file is being created has been exhausted.
.TP 15
[EIO]
An I/O error occurred while making the directory entry or
allocating the inode for O_CREAT.
.TP 15
[ETXTBSY]
The file is a pure procedure (shared text) file that is being
executed and the \fIopen\fP call requests write access.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.TP 15
[EEXIST]
O_CREAT and O_EXCL were specified and the file exists.
.TP 15
[EOPNOTSUPP]
An attempt was made to open a socket (not currently implemented).
.SH "SEE ALSO"
chmod(2), close(2), dup(2), getdtablesize(2),
lseek(2), read(2), write(2), umask(2)
