.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mknod.2	6.4 (Berkeley) 5/23/86
.\"
.TH MKNOD 2 "May 23, 1986"
.UC 4
.SH NAME
mknod \- make a special file
.SH SYNOPSIS
.nf
.ft B
mknod(path, mode, dev)
char *path;
int mode, dev;
.fi
.ft R
.SH DESCRIPTION
.I Mknod
creates a new file
whose name is
.I path.
The mode of the new file
(including special file bits)
is initialized from
.IR mode .
(The protection part of the mode
is modified by the process's mode mask (see
.IR umask (2))).
The first block pointer of the i-node
is initialized from
.I dev 
and is used to specify which device the special file
refers to.
.PP
If mode indicates a block or character special file,
.I dev
is a configuration dependent specification of a character or block
I/O device.  If
.I mode
does not indicate a block special or character special device,
.I dev
is ignored.
.PP
.I Mknod
may be invoked only by the super-user.
.SH "RETURN VALUE
Upon successful completion a value of 0 is returned.
Otherwise, a value of \-1 is returned and \fIerrno\fP
is set to indicate the error.
.SH ERRORS
.I Mknod
will fail and the file mode will be unchanged if:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
A component of the path prefix does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The process's effective user ID is not super-user.
.TP 15
[EPERM]
The pathname contains a character with the high-order bit set.
.TP 15
[EIO]
An I/O error occurred while making the directory entry or allocating the inode.
.TP 15
[ENOSPC]
The directory in which the entry for the new node is being placed
cannot be extended because there is no space left on the file
system containing the directory.
.TP 15
[ENOSPC]
There are no free inodes on the file system on which the
node is being created.
.TP 15
[EDQUOT]
The directory in which the entry for the new node
is being placed cannot be extended because the
user's quota of disk blocks on the file system
containing the directory has been exhausted.
.TP 15
[EDQUOT]
The user's quota of inodes on the file system on
which the node is being created has been exhausted.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EEXIST]
The named file exists.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.SH "SEE ALSO"
chmod(2), stat(2), umask(2)
