.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)killpg.2	6.3 (Berkeley) 5/14/86
.\"
.TH KILLPG 2 "May 14, 1986"
.UC 4
.SH NAME
killpg \- send signal to a process group
.SH SYNOPSIS
.ft B
killpg(pgrp, sig)
.br
int pgrp, sig;
.ft R
.SH DESCRIPTION
.I Killpg
sends the signal
.I sig
to the process group
.IR pgrp .
See
.IR sigvec (2)
for a list of signals.
.PP
The sending process and members of the process group must
have the same effective user ID, or
the sender must be the super-user.
As a single special case the continue signal SIGCONT may be sent
to any process that is a descendant of the current process.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.  Otherwise,
a value of \-1 is returned and the global variable \fIerrno\fP
is set to indicate the error.
.SH "ERRORS
\fIKillpg\fP will fail and no signal will be sent if any of the
following occur:
.TP 15
[EINVAL]
\fISig\fP is not a valid signal number.
.TP 15
[ESRCH]
No process can be found in the process group specified by \fIpgrp\fP.
.TP 15
[ESRCH]
The process group was given as 0
but the sending process does not have a process group.
.TP 15
[EPERM]
The sending process is not the super-user and one or more
of the target processes has an effective user ID different from that
of the sending process.
.SH "SEE ALSO"
kill(2), getpgrp(2), sigvec(2)
