.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ioctl.2	6.3 (Berkeley) 3/4/86
.\"
.TH IOCTL 2 "March 4, 1986"
.UC 4
.SH NAME
ioctl \- control device
.SH SYNOPSIS
.nf
.ft B
#include <sys/ioctl.h>
.PP
.ft B
ioctl(d, request, argp)
int d;
unsigned long request;
char *argp;
.fi
.ft R
.SH DESCRIPTION
.I Ioctl
performs a variety of functions
on open descriptors.  In particular, many operating
characteristics of character special files (e.g. terminals)
may be controlled with
.I ioctl
requests.
The writeups of various devices in section 4 discuss how
.I ioctl
applies to them.
.PP
An  ioctl
.I request
has encoded in it whether the argument is an \*(lqin\*(rq parameter
or \*(lqout\*(rq parameter, and the size of the argument \fIargp\fP in bytes.
Macros and defines used in specifying an ioctl
.I request
are located in the file
.IR <sys/ioctl.h> .
.SH "RETURN VALUE
If an error has occurred, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH ERRORS
.I Ioctl
will fail if one or more of the following are true:
.TP 15
[EBADF]
\fID\fP is not a valid descriptor.
.TP 15
[ENOTTY]
\fID\fP is not associated with a character
special device.
.TP 15
[ENOTTY]
The specified request does not apply to the kind
of object that the descriptor \fId\fP references.
.TP 15
[EINVAL]
\fIRequest\fP or \fIargp\fP is not valid.
.SH "SEE ALSO"
execve(2), fcntl(2), mt(4), tty(4), intro(4N)
