.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getuid.2	6.3 (Berkeley) 1/7/86
.\"
.TH GETUID 2 "January 7, 1986"
.UC 4
.SH NAME
getuid, geteuid \- get user identity
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
.PP
.ft B
.nf
uid = getuid()
uid_t uid;
.PP
.ft B
euid = geteuid()
uid_t euid;
.fi
.SH DESCRIPTION
.I Getuid
returns the real user ID of the current process,
.I geteuid
the effective user ID.
.PP
The real user ID identifies the person who is logged in.
The effective user ID
gives the process additional permissions during
execution of \*(lqset-user-ID\*(rq mode processes, which use
\fIgetuid\fP to determine the real-user-id of the process that
invoked them.
.SH "SEE ALSO"
getgid(2), setreuid(2)
