.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)gettimeofday.2	6.8 (Berkeley) 4/11/87
.\"
.TH GETTIMEOFDAY 2 "April 11, 1987"
.UC 4
.SH NAME
gettimeofday, settimeofday \- get/set date and time
.SH SYNOPSIS
.nf
.ft B
#include <sys/time.h>
.PP
.ft B
gettimeofday(tp, tzp)
struct timeval *tp;
struct timezone *tzp;
.PP
.ft B
settimeofday(tp, tzp)
struct timeval *tp;
struct timezone *tzp;
.fi
.SH DESCRIPTION
The system's notion of the current Greenwich time and the current time
zone is obtained with the \fIgettimeofday\fP call, and set with the
\fIsettimeofday\fP call.  The time is expressed in seconds and microseconds
since midnight (0 hour), January 1, 1970.  The resolution of the system
clock is hardware dependent, and the time may be updated continuously or
in ``ticks.''  If \fItp\fP or \fItzp\fP is NULL, the associated time
information will not be returned or set.
.PP
The structures pointed to by
.I tp
and
.I tzp
are defined in 
.I <sys/time.h>
as:
.PP
.nf
.RS
.DT
struct timeval {
	long	tv_sec;		/* seconds since Jan. 1, 1970 */
	long	tv_usec;		/* and microseconds */
};
.sp 1
struct timezone {
	int	tz_minuteswest;	/* of Greenwich */
	int	tz_dsttime;	/* type of dst correction to apply */
};
.RE
.fi
.PP
The 
.I timezone
structure indicates the local time zone
(measured in minutes of time westward from Greenwich),
and a flag that, if nonzero, indicates that
Daylight Saving time applies locally during
the appropriate part of the year.
.PP
Only the super-user may set the time of day or time zone.
.SH RETURN
A 0 return value indicates that the call succeeded.
A \-1 return value indicates an error occurred, and in this
case an error code is stored into the global variable \fIerrno\fP.
.SH "ERRORS
The following error codes may be set in \fIerrno\fP:
.TP 15
[EFAULT]
An argument address referenced invalid memory.
.TP 15
[EPERM]
A user other than the super-user attempted to set the time.
.SH "SEE ALSO"
date(1), adjtime(2), ctime(3), timed(8)
