.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getrusage.2	6.6 (Berkeley) 4/3/87
.\"
.TH GETRUSAGE 2 "April 3, 1987"
.UC 4
.SH NAME
getrusage \- get information about resource utilization
.SH SYNOPSIS
.nf
.ft B
#include <sys/time.h>
#include <sys/resource.h>
.PP
.ft B
.ta \w'#define 'u +\w'RUSAGE_CHILDREN  'u +\w'-1        'u
#define	RUSAGE_SELF	0	/* calling process */
#define	RUSAGE_CHILDREN	-1	/* terminated child processes */
.DT
.PP
.ft B
getrusage(who, rusage)
int who;
struct rusage *rusage;
.fi
.SH DESCRIPTION
.I Getrusage
returns information describing the resources utilized by the current
process, or all its terminated child processes.
The
.I who
parameter is one of RUSAGE_SELF or RUSAGE_CHILDREN.
The buffer to which
.I rusage
points will be filled in with
the following structure:
.PP
.nf
.RS
.ta \w'struct  'u +\w'struct  'u +3u*\w'struct  'u
struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	int	ru_maxrss;
	int	ru_ixrss;	/* integral shared text memory size */
	int	ru_idrss;	/* integral unshared data size */
	int	ru_isrss;	/* integral unshared stack size */
	int	ru_minflt;	/* page reclaims */
	int	ru_majflt;	/* page faults */
	int	ru_nswap;	/* swaps */
	int	ru_inblock;	/* block input operations */
	int	ru_oublock;	/* block output operations */
	int	ru_msgsnd;	/* messages sent */
	int	ru_msgrcv;	/* messages received */
	int	ru_nsignals;	/* signals received */
	int	ru_nvcsw;	/* voluntary context switches */
	int	ru_nivcsw;	/* involuntary context switches */
};
.RE
.DT
.fi
.PP
The fields are interpreted as follows:
.TP 15
ru_utime
the total amount of time spent executing in user mode.
.TP 15
ru_stime
the total amount of time spent in the system executing on behalf
of the process(es).
.TP 15
ru_maxrss
the maximum resident set size utilized (in kilobytes).
.TP 15
ru_ixrss
an \*(lqintegral\*(rq value indicating the amount of memory used
by the text segment
that was also shared among other processes.  This value is expressed
in units of kilobytes * ticks-of-execution.
.TP 15
ru_idrss
an integral value of the amount of unshared memory residing in the
data segment of a process (expressed in units of
kilobytes * ticks-of-execution).
.TP 15
ru_isrss
an integral value of the amount of unshared memory residing in the
stack segment of a process (expressed in units of
kilobytes * ticks-of-execution).
.TP 15
ru_minflt
the number of page faults serviced without any I/O activity; here
I/O activity is avoided by \*(lqreclaiming\*(rq a page frame from
the list of pages awaiting reallocation.
.TP 15
ru_majflt
the number of page faults serviced that required I/O activity.
.TP 15
ru_nswap
the number of times a process was \*(lqswapped\*(rq out of main
memory.
.TP 15
ru_inblock
the number of times the file system had to perform input.
.TP 15
ru_oublock
the number of times the file system had to perform output.
.TP 15
ru_msgsnd
the number of IPC messages sent.
.TP 15
ru_msgrcv
the number of IPC messages received.
.TP 15
ru_nsignals
the number of signals delivered.
.TP 15
ru_nvcsw
the number of times a context switch resulted due to a process
voluntarily giving up the processor before its time slice was
completed (usually to await availability of a resource).
.TP 15
ru_nivcsw
the number of times a context switch resulted due to a higher
priority process becoming runnable or because the current process
exceeded its time slice.
.SH NOTES
The numbers 
.I ru_inblock
and 
.I ru_oublock
account only for real
I/O; data supplied by the caching mechanism is charged only
to the first process to read or write the data.
.SH ERRORS
The possible errors for
.I getrusage
are:
.TP 15
[EINVAL]
The
.I who
parameter is not a valid value.
.TP 15
[EFAULT]
The address specified by the
.I rusage
parameter is not in a valid part of the process address space.
.SH SEE ALSO
gettimeofday(2), wait(2)
.SH BUGS
There is no way to obtain information about a child process
that has not yet terminated.
