.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getrlimit.2	6.4 (Berkeley) 4/3/87
.\"
.TH GETRLIMIT 2 "April 3, 1987"
.UC 4
.SH NAME
getrlimit, setrlimit \- control maximum system resource consumption
.SH SYNOPSIS
.ft B
.nf
#include <sys/time.h>
#include <sys/resource.h>
.PP
.ft B
getrlimit(resource, rlp)
int resource;
struct rlimit *rlp;
.PP
.ft B
setrlimit(resource, rlp)
int resource;
struct rlimit *rlp;
.fi
.ft R
.SH DESCRIPTION
Limits on the consumption of system resources by the current process
and each process it creates may be obtained with the
.I getrlimit
call, and set with the
.I setrlimit
call.  
.PP
The
.I resource
parameter is one of the following:
.TP 17
RLIMIT_CPU
the maximum amount of cpu time (in seconds) to be used by
each process.
.TP 17
RLIMIT_FSIZE
the largest size, in bytes, of any single file that may be created.
.TP 17
RLIMIT_DATA
the maximum size, in bytes, of the data segment for a process;
this defines how far a program may extend its break with the
.IR sbrk (2)
system call.
.TP 17
RLIMIT_STACK
the maximum size, in bytes, of the stack segment for a process;
this defines how far a program's stack segment may be extended.
Stack extension is performed automatically by the system.
.TP 17
RLIMIT_CORE
the largest size, in bytes, of a 
.I core
file that may be created.
.TP 17
RLIMIT_RSS
the maximum size, in bytes, to which a process's resident set size may
grow.  This imposes a limit on the amount of physical memory
to be given to a process; if memory is tight, the system will
prefer to take memory from processes that are exceeding their
declared resident set size.
.PP
A resource limit is specified as a soft limit and a hard limit.  When a
soft limit is exceeded a process may receive a signal (for example, if
the cpu time or file size is exceeded), but it will be allowed to
continue execution until it reaches the hard limit (or modifies
its resource limit).  The 
.I rlimit
structure is used to specify the hard and soft limits on a resource,
.PP
.nf
.RS
.DT
struct rlimit {
	int	rlim_cur;	/* current (soft) limit */
	int	rlim_max;	/* hard limit */
};
.RE
.fi
.PP
Only the super-user may raise the maximum limits.  Other users
may only alter 
.I rlim_cur
within the range from 0 to 
.I rlim_max
or (irreversibly) lower
.IR rlim_max .
.PP
An \*(lqinfinite\*(rq value for a limit is defined as RLIM_INFINITY
(0x7\&f\&f\&f\&f\&f\&f\&f).
.PP
Because this information is stored in the per-process information,
this system call must be executed directly by the shell if it
is to affect all future processes created by the shell;
.I limit
is thus a built-in command to
.IR csh (1).
.PP
The system refuses to extend the data or stack space when the limits
would be exceeded in the normal way: a
.I break
call fails if the data space limit is reached.
When the stack limit is reached, the process receives
a segmentation fault (SIGSEGV); if this signal is not
caught by a handler using the signal stack, this signal
will kill the process.
.PP
A file I/O operation that would create a file larger that the process'
soft limit will cause the write to fail and a signal SIGXFSZ to be
generated; this normally terminates the process, but may be caught.  When
the soft cpu time limit is exceeded, a signal SIGXCPU is sent to the
offending process.
.SH "RETURN VALUE
A 0 return value indicates that the call succeeded, changing
or returning the resource limit.   A return value of \-1 indicates
that an error occurred, and an error code is stored in the global
location \fIerrno\fP.
.SH "ERRORS
The possible errors are:
.TP 15
[EFAULT]
The address specified for \fIrlp\fP is invalid.
.TP 15
[EPERM]	The limit specified to \fIsetrlimit\fP would have
raised the maximum limit value, and the caller is not the super-user.
.SH SEE ALSO
csh(1), quota(2), sigvec(2), sigstack(2)
.SH BUGS
There should be 
.I limit
and
.I unlimit
commands in
.IR sh (1)
as well as in
.IR csh.
