.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getpriority.2	6.5 (Berkeley) 5/22/86
.\"
.TH GETPRIORITY 2 "May 22, 1986"
.UC 4
.SH NAME
getpriority, setpriority \- get/set program scheduling priority
.SH SYNOPSIS
.nf
.ft B
#include <sys/resource.h>
.PP
.ft B
prio = getpriority(which, who)
int prio, which, who;
.PP
.ft B
setpriority(which, who, prio)
int which, who, prio;
.fi
.SH DESCRIPTION
The scheduling
priority of the process, process group, or user, as indicated by
.I which
and
.I who
is obtained with the
.I getpriority
call and set with the
.I setpriority
call.
.I Which
is one of PRIO_PROCESS, PRIO_PGRP, or PRIO_USER, and 
.I who
is interpreted relative to 
.I which
(a process identifier for PRIO_PROCESS, process group
identifier for PRIO_PGRP, and a user ID for PRIO_USER).
A zero value of
.I who
denotes the current process, process group, or user.
.I Prio
is a value in the range \-20 to 20.  The default priority is 0;
lower priorities cause more favorable scheduling.
.PP
The
.I getpriority
call returns the highest priority (lowest numerical value)
enjoyed by any of the specified processes.  The
.I setpriority
call sets the priorities of all of the specified processes
to the specified value.  Only the super-user may lower priorities.
.SH "RETURN VALUE
Since
.I getpriority
can legitimately return the value \-1, it is necessary
to clear the external variable \fIerrno\fP prior to the
call, then check it afterward to determine
if a \-1 is an error or a legitimate value.
The
.I setpriority
call returns 0 if there is no error, or
\-1 if there is.
.SH ERRORS
.I Getpriority
and
.I setpriority
may return one of the following errors:
.TP 15
[ESRCH]
No process was located using the 
.I which
and
.I who
values specified.
.TP 15
[EINVAL]
.I Which
was not one of PRIO_PROCESS, PRIO_PGRP, or PRIO_USER.
.PP
In addition to the errors indicated above,
.I setpriority
may fail with one of the following errors returned:
.TP 15
[EPERM]
A process was located, but neither its effective nor real user
ID matched the effective user ID of the caller.
.TP 15
[EACCES]
A non super-user attempted to lower a process priority.
.SH "SEE ALSO"
nice(1), fork(2), renice(8)
