.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getgroups.2	6.4 (Berkeley) 4/10/87
.\"
.TH GETGROUPS 2 "April 10, 1987"
.UC 5
.SH NAME
getgroups \- get group access list
.SH SYNOPSIS
.nf
.ft B
#include <sys/param.h>
.PP
.ft B
ngroups = getgroups(gidsetlen, gidset)
int ngroups, gidsetlen, *gidset;
.fi
.SH DESCRIPTION
.I Getgroups
gets the current group access list of the user process
and stores it in the array 
.IR gidset .
The parameter
.I gidsetlen
indicates the number of entries that may be placed in 
.IR gidset.
.I Getgroups
returns the actual number of groups returned in
.IR gidset .
No more than NGROUPS, as defined in
.RI < sys/param.h >,
will ever
be returned.
.SH "RETURN VALUE
A successful call returns the number of groups in the group set.
A value of \-1 indicates that an error occurred, and the error
code is stored in the global variable \fIerrno\fP\|.
.SH "ERRORS
The possible errors for \fIgetgroup\fP are:
.TP 15
[EINVAL]
The argument
.I gidsetlen
is smaller than the number of groups in the group set.
.TP
[EFAULT]
The argument \fIgidset\fP specifies
an invalid address.
.SH "SEE ALSO
setgroups(2), initgroups(3)
.SH BUGS
The
.I gidset
array should be of type
.BR gid_t ,
but remains integer for compatibility with earlier systems.
