.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getgid.2	6.2 (Berkeley) 1/7/86
.\"
.TH GETGID 2 "January 7, 1986"
.UC 5
.SH NAME
getgid, getegid \- get group identity
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
.PP
.nf
.ft B
gid = getgid()
gid_t gid;
.PP
.ft B
egid = getegid()
gid_t egid;
.fi
.SH DESCRIPTION
.I Getgid
returns the real group ID of the current process,
.I getegid
the effective group ID.
.PP
The real group ID is specified at login time.
.PP
The effective group ID is more transient, and determines
additional access permission during execution of a
``set-group-ID'' process, and it is for such processes
that \fIgetgid\fP is most useful.
.SH "SEE ALSO"
getuid(2), setregid(2), setgid(3)
