.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)fork.2	6.4 (Berkeley) 5/22/86
.\"
.TH FORK 2 "May 22, 1986"
.UC
.SH NAME
fork \- create a new process
.SH SYNOPSIS
.ft B
pid = fork()
.br
int pid;
.ft R
.SH DESCRIPTION
.I Fork
causes creation of a new process.
The new process (child process) is an exact copy of the
calling process except for the following:
.in +5n
.sp
The child process has a unique process ID.
.sp
The child process has a different parent process ID (i.e.,
the process ID of the parent process).
.sp
The child process has its own copy of the parent's descriptors.
These descriptors reference the same underlying objects, so that,
for instance, file pointers in file objects are shared between
the child and the parent, so that an
.IR lseek (2)
on a descriptor in the child process can affect a subsequent
.I read
or
.I write
by the parent.
This descriptor copying is also used by the shell to
establish standard input and output for newly created processes
as well as to set up pipes.
.sp
The child processes resource utilizations are set to 0;
see
.IR setrlimit (2).
.SH "RETURN VALUE
Upon successful completion, \fIfork\fP returns a value
of 0 to the child process and returns the process ID of the child
process to the parent process.  Otherwise, a value of \-1 is returned
to the parent process, no child process is created, and the global
variable \fIerrno\fP is set to indicate the error.
.SH ERRORS
.I Fork
will fail and no child process will be created if one or more of the
following are true:
.TP 15
[EAGAIN]
The system-imposed limit on the total
number of processes under execution would be exceeded.
This limit is configuration-dependent.
.TP 15
[EAGAIN]
The system-imposed limit MAXUPRC (\fI<sys/param.h>) \fRon the total number of
processes under execution by a single user would be exceeded.
.TP 15
[ENOMEM]
There is insufficient swap space for the new process.
.SH "SEE ALSO"
execve(2), wait(2)
