.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)dup.2	6.3 (Berkeley) 5/13/86
.\"
.TH DUP 2 "May 13, 1986"
.UC 4
.SH NAME
dup, dup2 \- duplicate a descriptor
.SH SYNOPSIS
.nf
.ft B
newd = dup(oldd)
int newd, oldd;
.PP
.ft B
dup2(oldd, newd)
int oldd, newd;
.fi
.SH DESCRIPTION
.I Dup
duplicates an existing object descriptor.
The argument \fIoldd\fP is a small non-negative integer index in
the per-process descriptor table.  The value must be less
than the size of the table, which is returned by
.IR getdtablesize (2).
The new descriptor returned by the call,
.I newd,
is the lowest numbered descriptor that is
not currently in use by the process.
.PP
The object referenced by the descriptor does not distinguish
between references using \fIoldd\fP and \fInewd\fP in any way.
Thus if \fInewd\fP and \fIoldd\fP are duplicate references to an open
file,
.IR read (2),
.IR write (2)
and
.IR lseek (2)
calls all move a single pointer into the file,
and append mode, non-blocking I/O and asynchronous I/O options
are shared between the references.
If a separate pointer into the file is desired, a different
object reference to the file must be obtained by issuing an
additional
.IR open (2)
call.
The close-on-exec flag on the new file descriptor is unset.
.PP
In the second form of the call, the value of
.IR newd
desired is specified.  If this descriptor is already
in use, the descriptor is first deallocated as if a
.IR close (2)
call had been done first.
.SH "RETURN VALUE
The value \-1 is returned if an error occurs in either call.
The external variable
.I errno
indicates the cause of the error.
.SH "ERRORS
.I Dup
and
.I dup2
fail if:
.TP 15
[EBADF]
\fIOldd\fP or
\fInewd\fP is not a valid active descriptor
.TP 15
[EMFILE]
Too many descriptors are active.
.SH "SEE ALSO"
accept(2),
open(2),
close(2),
fcntl(2),
pipe(2),
socket(2),
socketpair(2),
getdtablesize(2)
