.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)chmod.2	6.5 (Berkeley) 5/13/86
.\"
.TH CHMOD 2 "May 13, 1986"
.UC 4
.SH NAME
chmod \- change mode of file
.SH SYNOPSIS
.nf
.ft B
chmod(path, mode)
char *path;
int mode;
.PP
.ft B
fchmod(fd, mode)
int fd, mode;
.fi
.SH DESCRIPTION
The file whose name
is given by \fIpath\fP
or referenced by the descriptor
.I fd
has its mode changed to
.IR mode .
Modes are constructed by
.IR or 'ing
together some
combination of the following, defined in
.IR <sys/inode.h> :
.PP
.RS
.nf
.ta \w'IWRITE\ \ 'u +\w'04000\ \ \ 'u
ISUID	04000	set user ID on execution
ISGID	02000	set group ID on execution
ISVTX	01000	`sticky bit' (see below)
IREAD	00400	read by owner
IWRITE	00200	write by owner
IEXEC	00100	execute (search on directory) by owner
	00070	read, write, execute (search) by group
	00007	read, write, execute (search) by others
.fi
.RE
.PP
If an executable file is set up for sharing (this is the default)
then mode ISVTX (the `sticky bit') prevents the system from
abandoning the swap-space image of the program-text portion
of the file when its last user terminates.
Ability to set this bit on executable files is restricted to the super-user.
.PP
If mode ISVTX (the `sticky bit') is set on a directory,
an unprivileged user may not delete or rename
files of other users in that directory.
For more details of the properties of the sticky bit, see
.IR sticky (8).
.PP
Only the owner of a file (or the super-user) may change the mode.
.PP
Writing or changing the owner of a file
turns off the set-user-id and set-group-id bits
unless the user is the super-user.
This makes the system somewhat more secure
by protecting set-user-id (set-group-id) files
from remaining set-user-id (set-group-id) if they are modified,
at the expense of a degree of compatibility.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.
Otherwise, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH "ERRORS
.I Chmod
will fail and the file mode will be unchanged if:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The effective user ID does not match the owner of the file and
the effective user ID is not the super-user.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.PP
.I Fchmod
will fail if:
.TP 15
[EBADF]
The descriptor is not valid.
.TP 15
[EINVAL]
.I Fd
refers to a socket, not to a file.
.TP 15
[EROFS]
The file resides on a read-only file system.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.SH "SEE ALSO"
chmod(1), open(2), chown(2), stat(2), sticky(8)
