.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)brk.2	6.4 (Berkeley) 6/17/86
.\"
.TH BRK 2 "June 17, 1986"
.UC 4
.SH NAME
brk, sbrk \- change data segment size
.SH SYNOPSIS
.nf
#include <sys/types.h>
.PP
.ft B
char *brk(addr)
char *addr;
.PP
.ft B
char *sbrk(incr)
int incr;
.fi
.SH DESCRIPTION
.I Brk
sets the system's idea of the lowest data segment 
location not used by the program (called the break)
to
.I addr
(rounded up to the next multiple of the system's page size).
Locations greater than
.I addr
and below the stack pointer
are not in the address space and will thus
cause a memory violation if accessed.
.PP
In the alternate function
.IR sbrk ,
.I incr
more bytes are added to the
program's data space and a pointer to the
start of the new area is returned.
.PP
When a program begins execution via
.I execve
the break is set at the
highest location defined by the program
and data storage areas.
Ordinarily, therefore, only programs with growing
data areas need to use
.IR sbrk .
.PP
The current value of the program break is reliably returned by
``sbrk(0)'' (see also 
.IR end (3)).
The
.IR getrlimit (2)
system call may be used to determine
the maximum permissible size of the
.I data
segment;
it will not be possible to set the break
beyond the
.I rlim_max
value returned from a call to
.IR getrlimit ,
e.g. \*(lqetext + rlp\(->rlim_max.\*(rq
(see
.IR end (3)
for the definition of
.IR etext ).
.SH "RETURN VALUE
Zero is returned if the 
.I brk
could be set;
\-1 if the program requests more
memory than the system limit.
.I Sbrk
returns \-1 if the break could not be set.
.SH ERRORS
.I Sbrk
will fail and no additional memory will be allocated if
one of the following are true:
.TP 15
[ENOMEM]
The limit, as set by
.IR setrlimit (2),
was exceeded.
.TP 15
[ENOMEM]
The maximum possible size of a data segment (compiled into the
system) was exceeded.
.TP 15
[ENOMEM]
Insufficient space existed in the swap area
to support the expansion.
.SH "SEE ALSO"
execve(2), getrlimit(2), malloc(3), end(3)
.SH BUGS
Setting the break may fail due to a temporary lack of
swap space.  It is not possible to distinguish this
from a failure caused by exceeding the maximum size of
the data segment without consulting 
.IR getrlimit .
