.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)bind.2	6.6 (Berkeley) 5/22/86
.\"
.TH BIND 2 "May 22, 1986"
.UC 5
.SH NAME
bind \- bind a name to a socket
.SH SYNOPSIS
.nf
.ft B
#include <sys/types.h>
#include <sys/socket.h>
.PP
.ft B
bind(s, name, namelen)
int s;
struct sockaddr *name;
int namelen;
.fi
.SH DESCRIPTION
.I Bind
assigns a name to an unnamed socket.
When a socket is created 
with
.IR socket (2)
it exists in a name space (address family)
but has no name assigned.
.I Bind
requests that
.IR name 
be assigned to the socket.
.SH NOTES
Binding a name in the UNIX domain creates a socket in the file
system that must be deleted by the caller when it is no longer
needed (using
.IR unlink (2)).
.PP
The rules used in name binding vary between communication domains.
Consult the manual entries in section 4 for detailed information.
.SH "RETURN VALUE
If the bind is successful, a 0 value is returned.
A return value of \-1 indicates an error, which is
further specified in the global \fIerrno\fP.
.SH ERRORS
The \fIbind\fP call will fail if:
.TP 20
[EBADF]
\fIS\fP is not a valid descriptor.
.TP 20
[ENOTSOCK]
\fIS\fP is not a socket.
.TP 20
[EADDRNOTAVAIL]
The specified address is not available from the local machine.
.TP 20
[EADDRINUSE]
The specified address is already in use.
.TP 20
[EINVAL]
The socket is already bound to an address.
.TP 20
[EACCES]
The requested address is protected, and the current user
has inadequate permission to access it.
.TP 20
[EFAULT]
The \fIname\fP parameter is not in a valid part of the user
address space.
.PP
The following errors are specific to binding names in the UNIX domain.
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
A prefix component of the path name does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EIO]
An I/O error occurred while making the directory entry or allocating the inode.
.TP 15
[EROFS]
The name would reside on a read-only file system.
.TP 15
[EISDIR]
A null pathname was specified.
.SH SEE ALSO
connect(2), listen(2), socket(2), getsockname(2)
