.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)acct.2	6.4 (Berkeley) 5/22/86
.\"
.TH ACCT 2 "May 22, 1986"
.UC 4
.SH NAME
acct \- turn accounting on or off
.SH SYNOPSIS
.nf
.ft B
acct(file)
char *file;
.ft R
.fi
.SH DESCRIPTION
The system is prepared to write a record
in an accounting
.I file
for each process as it terminates.
This
call, with a null-terminated string naming an existing file
as argument, turns on accounting;
records for each terminating process are appended to
.IR file .
An argument of 0 causes accounting to be turned off.
.PP
The accounting file format is given in
.IR acct (5).
.PP
This call is permitted only to the super-user.
.SH NOTES
Accounting is automatically disabled when the file system the
accounting file resides on runs out of space; it is enabled when
space once again becomes available.
.SH "RETURN VALUE
On error \-1 is returned.
The file must exist and the call may be exercised only by the super-user.
It is erroneous to try to turn on accounting when it is already on.
.SH ERRORS
.I Acct
will fail if one of the following is true:
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix,
or the path name is not a regular file.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EFAULT]
.I File
points outside the process's allocated address space.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.SH "SEE ALSO"
acct(5), sa(8)
.SH BUGS
No accounting is produced for programs running
when a crash occurs.
In particular non-terminating programs are never
accounted for.
