.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)cc.1	6.2 (Berkeley) 6/7/85
.\"
.TH CC 1 "June 7, 1985"
.UC 4
.SH NAME
cc \- C compiler
.SH SYNOPSIS
.B cc
[ option ] ... file ...
.SH DESCRIPTION
.I Cc
is the UNIX C compiler.
.I Cc
accepts several types of arguments:
.PP
Arguments whose names end with `.c' are taken to be
C source programs; they are compiled, and
each object program is left on the file
whose name is that of the source with `.o' substituted
for `.c'.
The `.o' file is normally deleted, however, if a single
C program is compiled and loaded all at one go.
.PP
In the same way,
arguments whose names end with `.s' are taken to be assembly source programs
and are assembled, producing a `.o' file.
.PP
The following options are interpreted by
.IR cc .
See
.IR ld (1)
for load-time options.
.TP 8
.B \-c
Suppress the loading phase of the compilation, and force
an object file to be produced even if only one program is compiled.
.TP
.B \-g
Have the compiler produce additional symbol table information
for 
.IR dbx (1).
Also pass the
.B \-lg
flag to
.IR ld (1).
.TP
.B \-go
Have the compiler produce additional symbol table information
for the obsolete debugger
.IR sdb (1).
Also pass the
.B \-lg
flag to
.IR ld (1).
.TP
.B \-w
Suppress warning diagnostics.
.TP
.B \-p
Arrange for the compiler to produce code
which counts the number of times each routine is called.
If loading takes place, replace the standard startup
routine by one which automatically calls
.IR monitor (3)
at the start and arranges to write out a
.I mon.out
file at normal termination of execution of the object program.
An execution profile can then be generated by
use of
.IR  prof (1).
.TP
.B \-pg
Causes the compiler to produce counting code in the manner of
.B \-p,
but invokes a run-time recording mechanism that keeps more
extensive statistics and produces a 
.I gmon.out
file at normal termination.
Also, a profiling library is searched, in lieu of the standard C library.
An execution profile can then be generated by  use of
.IR gprof (1).
.TP
.SM
.B \-O
Invoke an
object-code improver.
.TP
.SM
.B \-R
Passed on to
.I as,
making initialized variables shared and read-only.
.TP
.SM
.B \-S
Compile the named C programs, and leave the
assembler-language output on corresponding files suffixed `.s'.
.TP
.SM
.B \-M
Run only the macro preprocessor
on the named C programs,
requesting it to generate Makefile dependencies
and send the result to the standard output.
.TP
.SM
.B \-E
Run only the macro preprocessor
on the named C programs, and send the result to the
standard output.
.TP
.SM
.B \-C
prevent the macro preprocessor from eliding comments.
.TP
.BI \-o " output"
Name the final output file
.IR output .
If this option is used the file `a.out' will be left undisturbed.
.TP
.SM
.BI \-D name=def
.br
.ns
.TP
.SM
.BI \-D \*Sname
Define the
.I name
to the preprocessor,
as if by
`#define'.
If no definition is given, the name is defined as "1".
.TP
.SM
.BI \-U \*Sname
Remove any initial definition of
.IR name .
.TP
.SM
.BI \-I \*Sdir
`#include' files
whose names do not begin with `/' are always
sought first in the directory 
of the
.I file
argument,
then in directories named in 
.B \-I
options,
then in directories on a standard list.
.TP
.SM
.BI \-L \*Sdir
Library archives are sought first in
directories named in
.B \-L
options,
then in directories on a standard list.
.TP
.B \-f
Use an alternate compiler which does not convert expressions involving
only floats to double. This does not conform to the standard which states
that all intermediate results should be converted to double but does
provide a speed improvement for programs which don't require full double
precision.  This option also makes
.B "register float"
variables work appropriately.
.TP
.SM
.BI \-B \*Sstring
Find substitute compiler passes in the files named
.I string
with the suffixes cpp, ccom and c2.
If 
.I string 
is empty, use a standard backup version.
.TP
.BR \-t [ p012 ]
Find only the designated compiler passes in the
files whose names are constructed by a
.B \-B
option.
In the absence of a
.B \-B 
option, the
.I string
is taken to be `/usr/c/'.
.PP
Other arguments
are taken
to be either loader option arguments, or C-compatible
object programs, typically produced by an earlier
.I cc
run,
or perhaps libraries of C-compatible routines.
These programs, together with the results of any
compilations specified, are loaded (in the order
given) to produce an executable program with name
.B a.out.
.SH FILES
.ta \w'/usr/c/occom  'u
file.c	input file
.br
file.o	object file
.br
a.out	loaded output
.br
/tmp/ctm?	temporary
.br
/lib/cpp	preprocessor
.br
/lib/ccom	compiler
.br
/lib/sccom	compiler for single precision floats
.br
/usr/c/occom	backup compiler
.br
/usr/c/ocpp	backup preprocessor
.br
/lib/c2	optional optimizer
.br
/lib/crt0.o	runtime startoff
.br
/lib/mcrt0.o	startoff for profiling
.br
/usr/lib/gcrt0.o	startoff for gprof-profiling
.br
/lib/libc.a	standard library, see
.IR intro (3)
.br
/usr/lib/libc_p.a	profiling library, see
.IR intro (3)
.br
/usr/include	standard directory for `#include' files
.br
mon.out	file produced for analysis by
.IR prof (1)
.br
gmon.out	file produced for analysis by
.IR gprof (1)
.SH "SEE ALSO"
B. W. Kernighan and D. M. Ritchie,
.I The C Programming Language,
Prentice-Hall,
1978
.br
B. W. Kernighan,
.I
Programming in C\(ema tutorial
.br
D. M. Ritchie,
.I
C Reference Manual
.br
monitor(3), prof(1), gprof(1), adb(1), ld(1), dbx(1), as(1)
.SH DIAGNOSTICS
The diagnostics produced by C itself are intended to be
self-explanatory.
Occasional messages may be produced by the assembler
or loader.
.SH BUGS
The compiler currently ignores advice to put 
\fBchar\fR, \fBunsigned char\fR,
\fBshort\fR, \fBunsigned short\fR,
\fBfloat\fR, or \fBdouble\fR
variables in registers, except as noted above.  It previously
produced poor, and in some cases incorrect, code for such declarations.
