.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)termcap.5	6.5 (Berkeley) 9/30/87
.\"
.ie n \{\
.	ds lq \&"\"
.	ds rq \&"\"
.\}
.el \{\
.	ds rq ''
.	ds lq ``
.\}
.tr ||
.tr *\(**
.hw trans-parently
.TH TERMCAP 5 "1 November 1985"
.UC
.SH NAME
termcap \- terminal capability data base
.SH SYNOPSIS
/etc/termcap
.SH DESCRIPTION
.I Termcap\^
is a data base describing terminals,
used,
.IR e.g. ,
by
.IR vi\^ (1)
and
.IR curses\^ (3X).
Terminals are described in
.I termcap\^
by giving a set of capabilities that they have and by describing
how operations are performed.
Padding requirements and initialization sequences
are included in
.IR termcap\^ .
.PP
Entries in
.I termcap\^
consist of a number of `:'-separated fields.
The first entry for each terminal gives the names that are known for the
terminal, separated by `|' characters.
The first name is always two characters
long and is used by older systems which store the terminal type
in a 16-bit word in a system-wide data base.
The second name given is the most common abbreviation for the terminal,
the last name given should be a long name fully identifying the terminal,
and all others are understood as synonyms for the terminal name.
All names but the first and last
should be in lower case and contain no blanks;
the last name may well contain
upper case and blanks for readability.
.PP
Terminal names (except for the last, verbose entry)
should be chosen using the following conventions.
The particular piece of hardware making up the terminal
should have a root name chosen, thus \*(lqhp2621\*(rq.
This name should not contain hyphens.
Modes that the hardware can be in
or user preferences
should be indicated by appending a hyphen and an indicator of the mode.
Therefore, a \*(lqvt100\*(rq in 132-column mode would be \*(lqvt100-w\*(rq.
The following suffixes should be used where possible:
.sp
.ev
.ta
.ta \w'\fBSuffix\fP\ \ \ 'u +\w'With automatic margins (usually default)\ \ 'u
.nf
.if t \{\
.nr Xx \n(.lu-\n(.i-\w'\fBSuffix\fP\ \ \ With automatic margins (usually default)\ \ vt100-am'u
.in +\n(Xxu/2u
.\}
\fBSuffix	Meaning	Example\fP
-w	Wide mode (more than 80 columns)	vt100-w
-am	With automatic margins (usually default)	vt100-am
-nam	Without automatic margins	vt100-nam
-\fIn\fP	Number of lines on the screen	aaa-60
-na	No arrow keys (leave them in local)	concept100-na
-\fIn\^\fPp	Number of pages of memory	concept100-4p
-rv	Reverse video	concept100-rv
.fi
.ev
.SH CAPABILITIES
.PP
The characters in the
.I Notes
field in the table have the following meanings
(more than one may apply to a capability):
.PP
.ev
.ta
.ta \w'N\ \ \ 'u
.nf
N	indicates numeric parameter(s)
P	indicates that padding may be specified
*	indicates that padding may be based on the number of lines affected
o	indicates capability is obsolete
.fi
.ev
.PP
\*(lqObsolete\*(rq capabilities have no
.I terminfo\^
equivalents,
since they were considered useless,
or are subsumed by other capabilities.
New software should not rely on them at all.
.PP
.nf
.ta \w'\fBName  \fP'u +\w'\fBType  \fP'u +\w'\fBNotes  \fP'u
\fBName	Type	Notes	Description\fP
ae	str	(P)	End alternate character set
AL	str	(NP*)	Add \fIn\^\fP new blank lines
al	str	(P*)	Add new blank line
am	bool		Terminal has automatic margins
as	str	(P)	Start alternate character set
bc	str	(o)	Backspace if not \fB^H\fP
bl	str	(P)	Audible signal (bell)
bs	bool	(o)	Terminal can backspace with \fB^H\fP
bt	str	(P)	Back tab
bw	bool		\fBle\fP (backspace) wraps from column 0 to last column
CC	str		Terminal settable command character in prototype
cd	str	(P*)	Clear to end of display
ce	str	(P)	Clear to end of line
ch	str	(NP)	Set cursor column (horizontal position)
cl	str	(P*)	Clear screen and home cursor
CM	str	(NP)	Memory-relative cursor addressing
cm	str	(NP)	Screen-relative cursor motion
co	num		Number of columns in a line (See BUGS section below)
cr	str	(P)	Carriage return
cs	str	(NP)	Change scrolling region (VT100)
ct	str	(P)	Clear all tab stops
cv	str	(NP)	Set cursor row (vertical position)
da	bool		Display may be retained above the screen
dB	num	(o)	Milliseconds of \fBbs\fP delay needed (default 0)
db	bool		Display may be retained below the screen
DC	str	(NP*)	Delete \fIn\^\fP characters
dC	num	(o)	Milliseconds of \fBcr\fP delay needed (default 0)
dc	str	(P*)	Delete character
dF	num	(o)	Milliseconds of \fBff\fP delay needed (default 0)
DL	str	(NP*)	Delete \fIn\^\fP lines
dl	str	(P*)	Delete line
dm	str		Enter delete mode
dN	num	(o)	Milliseconds of \fBnl\fP delay needed (default 0)
DO	str	(NP*)	Move cursor down \fIn\^\fP lines
do	str		Down one line
ds	str		Disable status line
dT	num	(o)	Milliseconds of horizontal tab delay needed (default 0)
dV	num	(o)	Milliseconds of vertical tab delay needed (default 0)
ec	str	(NP)	Erase \fIn\^\fP characters
ed	str		End delete mode
ei	str		End insert mode
eo	bool		Can erase overstrikes with a blank
EP	bool	(o)	Even parity
es	bool		Escape can be used on the status line
ff	str	(P*)	Hardcopy terminal page eject
fs	str		Return from status line
gn	bool		Generic line type (\fIe.g.\fP dialup, switch)
hc	bool		Hardcopy terminal
HD	bool	(o)	Half-duplex
hd	str		Half-line down (forward 1/2 linefeed)
ho	str	(P)	Home cursor
hs	bool		Has extra \*(lqstatus line\*(rq
hu	str		Half-line up (reverse 1/2 linefeed)
hz	bool		Cannot print ~s (Hazeltine)
i1-i3	str		Terminal initialization strings (\fIterminfo\^\fP only)
IC	str	(NP*)	Insert \fIn\^\fP blank characters
ic	str	(P*)	Insert character
if	str		Name of file containing initialization string
im	str		Enter insert mode
in	bool		Insert mode distinguishes nulls
iP	str		Pathname of program for initialization (\fIterminfo\^\fP only)
ip	str	(P*)	Insert pad after character inserted
is	str		Terminal initialization string (\fItermcap\^\fP only)
it	num		Tabs initially every \fIn\^\fP positions
K1	str		Sent by keypad upper left
K2	str		Sent by keypad upper right
K3	str		Sent by keypad center
K4	str		Sent by keypad lower left
K5	str		Sent by keypad lower right
k0-k9	str		Sent by function keys 0-9
kA	str		Sent by insert-line key
ka	str		Sent by clear-all-tabs key
kb	str		Sent by backspace key
kC	str		Sent by clear-screen or erase key
kD	str		Sent by delete-character key
kd	str		Sent by down-arrow key
kE	str		Sent by clear-to-end-of-line key
ke	str		Out of \*(lqkeypad transmit\*(rq mode
kF	str		Sent by scroll-forward/down key
kH	str		Sent by home-down key
kh	str		Sent by home key
kI	str		Sent by insert-character or enter-insert-mode key
kL	str		Sent by delete-line key
kl	str		Sent by left-arrow key
kM	str		Sent by insert key while in insert mode
km	bool		Has a \*(lqmeta\*(rq key (shift, sets parity bit)
kN	str		Sent by next-page key
kn	num	(o)	Number of function (\fBk0\fP\-\fBk9\fP) keys (default 0)
ko	str	(o)	Termcap entries for other non-function keys
kP	str		Sent by previous-page key
kR	str		Sent by scroll-backward/up key
kr	str		Sent by right-arrow key
kS	str		Sent by clear-to-end-of-screen key
ks	str		Put terminal in \*(lqkeypad transmit\*(rq mode
kT	str		Sent by set-tab key
kt	str		Sent by clear-tab key
ku	str		Sent by up-arrow key
l0-l9	str		Labels on function keys if not \*(lqf\fIn\^\fP\*(rq
LC	bool	(o)	Lower-case only
LE	str	(NP)	Move cursor left \fIn\^\fP positions
le	str	(P)	Move cursor left one position
li	num		Number of lines on screen or page (See BUGS section below)
ll	str		Last line, first column
lm	num		Lines of memory if > \fBli\fP (0 means varies)
ma	str	(o)	Arrow key map (used by \fIvi\^\fP version 2 only)
mb	str		Turn on blinking attribute
md	str		Turn on bold (extra bright) attribute
me	str		Turn off all attributes
mh	str		Turn on half-bright attribute
mi	bool		Safe to move while in insert mode
mk	str		Turn on blank attribute (characters invisible)
ml	str	(o)	Memory lock on above cursor
mm	str		Turn on \*(lqmeta mode\*(rq (8th bit)
mo	str		Turn off \*(lqmeta mode\*(rq
mp	str		Turn on protected attribute
mr	str		Turn on reverse-video attibute
ms	bool		Safe to move in standout modes
mu	str	(o)	Memory unlock (turn off memory lock)
nc	bool	(o)	No correctly-working \fBcr\fP (Datamedia 2500, Hazeltine 2000)
nd	str		Non-destructive space (cursor right)
NL	bool	(o)	\fB\\n\fP is newline, not line feed
nl	str	(o)	Newline character if not \fB\\n\fP
ns	bool	(o)	Terminal is a \s-1CRT\s0 but doesn't scroll
nw	str	(P)	Newline (behaves like \fBcr\fP followed by \fBdo\fP)
OP	bool	(o)	Odd parity
os	bool		Terminal overstrikes
pb	num		Lowest baud where delays are required
pc	str		Pad character (default \s-2NUL\s0)
pf	str		Turn off the printer
pk	str		Program function key \fIn\^\fP to type string \fIs\fP (\fIterminfo\^\fP only)
pl	str		Program function key \fIn\^\fP to execute string \fIs\fP (\fIterminfo\^\fP only)
pO	str	(N)	Turn on the printer for \fIn\^\fP bytes
po	str		Turn on the printer
ps	str		Print contents of the screen
pt	bool	(o)	Has hardware tabs (may need to be set with \fBis\fP)
px	str		Program function key \fIn\^\fP to transmit string \fIs\fP (\fIterminfo\^\fP only)
r1-r3	str		Reset terminal completely to sane modes (\fIterminfo\^\fP only)
rc	str	(P)	Restore cursor to position of last \fBsc\fP
rf	str		Name of file containing reset codes
RI	str	(NP)	Move cursor right \fIn\^\fP positions
rp	str	(NP*)	Repeat character \fIc n\^\fP times
rs	str		Reset terminal completely to sane modes (\fItermcap\^\fP only)
sa	str	(NP)	Define the video attributes
sc	str	(P)	Save cursor position
se	str		End standout mode
SF	str	(NP*)	Scroll forward \fIn\^\fP lines
sf	str	(P)	Scroll text up
sg	num		Number of garbage chars left by \fBso\fP or \fBse\fP (default 0)
so	str		Begin standout mode
SR	str	(NP*)	Scroll backward \fIn\^\fP lines
sr	str	(P)	Scroll text down
st	str		Set a tab in all rows, current column
ta	str	(P)	Tab to next 8-position hardware tab stop
tc	str		Entry of similar terminal \- must be last
te	str		String to end programs that use \fItermcap\fP
ti	str		String to begin programs that use \fItermcap\fP
ts	str	(N)	Go to status line, column \fIn\^\fP
UC	bool	(o)	Upper-case only
uc	str		Underscore one character and move past it
ue	str		End underscore mode
ug	num		Number of garbage chars left by \fBus\fP or \fBue\fP (default 0)
ul	bool		Underline character overstrikes
UP	str	(NP*)	Move cursor up \fIn\^\fP lines
up	str		Upline (cursor up)
us	str		Start underscore mode
vb	str		Visible bell (must not move cursor)
ve	str		Make cursor appear normal (undo \fBvs\fP/\fBvi\fP)
vi	str		Make cursor invisible
vs	str		Make cursor very visible
vt	num		Virtual terminal number (not supported on all systems)
wi	str	(N)	Set current window
ws	num		Number of columns in status line
xb	bool		Beehive (f1=\s-2ESC\s0, f2=^C)
xn	bool		Newline ignored after 80 cols (Concept)
xo	bool		Terminal uses xoff/xon (\s-2DC3\s0/\s-2DC1\s0) handshaking
xr	bool	(o)	Return acts like \fBce cr nl\fP (Delta Data)
xs	bool		Standout not erased by overwriting (Hewlett-Packard)
xt	bool		Tabs ruin, magic \fBso\fP char (Teleray 1061)
xx	bool	(o)	Tektronix 4025 insert-line
.fi
.ta 8n +8n
.PP
.B A Sample Entry
.PP
The following entry, which describes the Concept\-100, is among the more
complex entries in the
.I termcap\^
file as of this writing.
.PP
.nf
ca\||\|concept100\||\|c100\||\|concept\||\|c104\||\|concept100-4p\||\|HDS Concept\-100:\e
	:al=3*\eE^R:am:bl=^G:cd=16*\eE^C:ce=16\eE^U:cl=2*^L:cm=\eEa%+ %+ :\e
	:co#80:.cr=9^M:db:dc=16\eE^A:dl=3*\eE^B:do=^J:ei=\eE\e200:eo:im=\eE^P:in:\e
	:ip=16*:is=\eEU\eEf\eE7\eE5\eE8\eEl\eENH\eEK\eE\e200\eEo&\e200\eEo\e47\eE:k1=\eE5:\e
	:k2=\eE6:k3=\eE7:kb=^h:kd=\eE<:ke=\eEx:kh=\eE?:kl=\eE>:kr=\eE=:ks=\eEX:\e
	:ku=\eE;:le=^H:li#24:mb=\eEC:me=\eEN\e200:mh=\eEE:mi:mk=\eEH:mp=\eEI:\e
	:mr=\eED:nd=\eE=:pb#9600:rp=0.2*\eEr%.%+ :se=\eEd\eEe:sf=^J:so=\eEE\eED:\e
	:.ta=8\et:te=\eEv    \e200\e200\e200\e200\e200\e200\eEp\er\en:\e
	:ti=\eEU\eEv  8p\eEp\er:ue=\eEg:ul:up=\eE;:us=\eEG:\e
	:vb=\eEk\e200\e200\e200\e200\e200\e200\e200\e200\e200\e200\e200\e200\e200\e200\eEK:\e
	:ve=\eEw:vs=\eEW:vt#8:xn:\e
	:bs:cr=^M:dC#9:dT#8:nl=^J:ta=^I:pt:
.fi
.PP
Entries may continue onto multiple lines by giving a \e as the last
character of a line, and empty fields
may be included for readability (here between the last field on a line
and the first field on the next).
Comments may be included on lines beginning with \*(lq#\*(rq.
.br
.ne 5
.PP
.B Types of Capabilities
.PP
Capabilities in
.I termcap\^
are of three types: Boolean capabilities,
which indicate particular features that the terminal has;
numeric capabilities,
giving the size of the display or the size of other attributes;
and string capabilities,
which give character sequences that can be used to perform particular
terminal operations.
All capabilities have two-letter codes.
For instance, the fact that
the Concept has
.I automatic margins
.RI ( i.e. ,
an automatic return and linefeed
when the end of a line is reached) is indicated by the Boolean capability
.BR am .
Hence the description of the Concept includes
.BR am .
.PP
Numeric capabilities are followed by the character `#' then the value.
In the example above
.BR co ,
which indicates the number of columns the display has,
gives the value `80' for the Concept.
.PP
Finally, string-valued capabilities, such as
.B ce
(clear-to-end-of-line
sequence) are given by the two-letter code, an `=', then a string
ending at the next following `:'.
A delay in milliseconds may appear after
the `=' in such a capability,
which causes padding characters to be supplied by
.I tputs\^
after the remainder of the string is sent to provide this delay.
The delay can be either a number,
.I e.g.
`20', or a number followed by
an `*',
.IR i.e. ,
`3*'.
An `*' indicates that the padding required is proportional
to the number of lines affected by the operation, and the amount given is
the per-affected-line padding required.
(In the case of insert-character,
the factor is still the number of
.I lines\^
affected;
this is always 1 unless the terminal has
.B in
and the software uses it.)
When an `*' is specified, it is sometimes useful to give a delay of the form
`3.5' to specify a delay per line to tenths of milliseconds.
(Only one decimal place is allowed.)
.PP
A number of escape sequences are provided in the string-valued capabilities
for easy encoding of control characters there.
.B \eE
maps to an \s-2ESC\s0
character,
.B ^X
maps to a control-X for any appropriate X,
and the sequences
.B \en
.B \er
.B \et
.B \eb
.B \ef
map to linefeed, return, tab, backspace, and formfeed, respectively.
Finally, characters may be given as three octal digits after a
.BR \e ,
and the characters
.B ^
and
.B \e
may be given as
.B \e^
and
.BR \e\e .
If it is necessary to place a
.B :
in a capability it must be escaped in
octal as
.BR \e072 .
If it is necessary to place a \s-2NUL\s0
character in a string capability it
must be encoded as
.BR \e200 .
(The routines that deal with
.I termcap\^
use C strings and strip the high bits of the output very late, so that
a
.B \e200
comes out as a
.B \e000
would.)
.PP
Sometimes individual capabilities must be commented out.
To do this, put a period before the capability name.
For example, see the first
.B cr
and
.B ta
in the example above.
.br
.ne 5
.PP
.B Preparing Descriptions
.PP
We now outline how to prepare descriptions of terminals.
The most effective way to prepare a terminal description is by imitating
the description of a similar terminal in
.I termcap\^
and to build up a description gradually, using partial descriptions
with
.I vi\^
to check that they are correct.
Be aware that a very unusual terminal may expose deficiencies in
the ability of the
.I termcap\^
file to describe it
or bugs in
.IR vi\^ .
To easily test a new terminal description you are working on
you can put it in your home directory in a file called
.I .termcap\^
and programs will look there before looking in
.IR /etc/termcap\^ .
You can also set the environment variable
.B
.SM TERMPATH
to a list of absolute file pathnames (separated by spaces or colons),
one of which contains the description you are working on,
and programs will search them in the order listed, and nowhere else.
See
.IR termcap\^ (3X).
The
.B
.SM TERMCAP
environment variable is usually set to the
.I termcap\^
entry itself
to avoid reading files when starting up a program.
.PP
To get the padding for insert-line right
(if the terminal manufacturer did not document it),
a severe test is to use
.I vi\^
to edit
.I /etc/passwd\^
at 9600 baud, delete roughly 16 lines from the middle of the screen,
then hit the `u' key several times quickly.
If the display messes up, more padding is usually needed.
A similar test can be used for insert-character.
.br
.ne 5
.PP
.B Basic Capabilities
.PP
The number of columns on each line of the display is given by the
.B co
numeric capability.
If the display is a \s-1CRT\s0, then the
number of lines on the screen is given by the
.B li
capability.
If the display wraps around to the beginning of the next line when
the cursor reaches the right margin, then it should have the
.B am
capability.
If the terminal can clear its screen,
the code to do this is given by the
.B cl
string capability.
If the terminal overstrikes
(rather than clearing the position when a character is overwritten),
it should have the
.B os
capability.
If the terminal is a printing terminal,
with no soft copy unit,
give it both
.B hc
and
.BR os .
.RB ( os
applies to storage scope terminals,
such as the Tektronix 4010 series,
as well as to hard copy and
.SM APL
terminals.)
If there is a code to move the cursor to the left edge of the current row,
give this as
.BR cr .
(Normally this will be carriage-return,
.BR ^M .)
If there is a code to produce an audible signal (bell, beep,
.IR etc.\^ ),
give this as
.BR bl .
.PP
If there is a code (such as backspace)
to move the cursor one position to the left,
that capability should be given as
.BR le .
Similarly,
codes to move to the right, up, and down
should be given as
.BR nd ,
.BR up ,
and
.BR do ,
respectively.
These
.I local cursor motions\^
should not alter the text they pass over;
for example, you would not normally use
\*(lqnd=\ \*(rq
unless the terminal has the
.B os
capability,
because the space would erase the character moved over.
.PP
A very important point here is that the local cursor motions encoded
in
.I termcap\^
have undefined behavior at the left and top edges of a
.SM CRT
display.
Programs should never attempt to backspace around the left edge,
unless
.B bw
is given, and never attempt to go up off the top
using local cursor motions.
.PP
In order to scroll text up,
a program goes to the bottom left corner of the screen and sends the
.B sf
(index) string.
To scroll text down,
a program goes to the top left corner of the screen and sends the
.B sr
(reverse index) string.
The strings
.B sf
and
.B sr
have undefined behavior
when not on their respective corners of the screen.
Parameterized versions of the scrolling sequences are
.B SF
and
.BR SR ,
which have the same semantics as
.B sf
and
.B sr
except that they take one parameter
and scroll that many lines.
They also have undefined behavior
except at the appropriate corner of the screen.
.PP
The
.B am
capability tells whether the cursor sticks at the right
edge of the screen when text is output there,
but this does not necessarily apply to
.B nd
from the last column.
Leftward local motion is defined from the left edge only when
.B bw
is given; then an
.B le
from the left edge will move to the right edge of the previous row.
This is useful for drawing a box around the edge of the screen,
for example.
If the terminal has switch-selectable automatic margins,
the
.I termcap\^
description usually assumes that this feature is on,
.IR i.e. ,
.BR am .
If the terminal has a command
that moves to the first column of the next line,
that command can be given as
.B nw
(newline).
It is permissible for this to clear the remainder of the current line,
so if the terminal has no correctly-working \s-2CR\s0 and \s-2LF\s0
it may still be possible to craft a working
.B nw
out of one or both of them.
.PP
These capabilities suffice to describe hardcopy and \*(lqglass-tty\*(rq terminals.
Thus the Teletype model 33 is described as
.PP
.nf
	T3\||\|tty33\||\|33\||\|tty\||\|Teletype model 33:\e
		:bl=^G:co#72:cr=^M:do=^J:hc:os:
.fi
.PP
and the Lear Siegler \s-1ADM\s0\-3 is described as
.PP
.nf
	l3\||\|adm3\||\|3\||\|LSI \s-1ADM\s0-3:\e
		:am:bl=^G:cl=^Z:co#80:cr=^M:do=^J:le=^H:li#24:sf=^J:
.fi
.br
.ne 5
.PP
.B Parameterized Strings
.PP
Cursor addressing and other strings requiring parameters
are described by a
parameterized string capability, with 
.IR printf\^ (3S)-like
escapes
.B %x
in it,
while other characters are passed through unchanged.
For example, to address the cursor the
.B cm
capability is given, using two parameters: the row and column to move to.
(Rows and columns are numbered from zero and refer to the physical screen
visible to the user, not to any unseen memory.
If the terminal has memory-relative cursor addressing,
that can be indicated by an analogous
.B CM
capability.)
.PP
The
.B %
encodings have the following meanings:
.PP
.DT
.nf
	%%	output `%'
	%d	output value as in \fIprintf\^\fP %d
	%2	output value as in \fIprintf\^\fP %2d
	%3	output value as in \fIprintf\^\fP %3d
	%.	output value as in \fIprintf\^\fP %c
	%+\fIx\fP	add \fIx\^\fP to value, then do %.
	%>\fIxy\fP	if value > \fIx\^\fP then add \fIy\^\fP, no output
	%r	reverse order of two parameters, no output
	%i	increment by one, no output
	%n	exclusive-or all parameters with 0140 (Datamedia 2500)
	%B	BCD (16*(value/10)) + (value%10), no output
	%D	Reverse coding (value \- 2*(value%16)), no output (Delta Data)
.fi
.PP
Consider the Hewlett-Packard 2645, which, to get to row 3 and column 12, needs
to be sent \*(lq\eE&a12c03Y\*(rq padded for 6 milliseconds.
Note that the order
of the row and column coordinates is reversed here
and that the row and column
are sent as two-digit integers.
Thus its
.B cm
capability is \*(lqcm=6\eE&%r%2c%2Y\*(rq.
.PP
The Microterm
.SM ACT-IV
needs the current row and column sent
simply encoded in binary
preceded by a
.BR ^T ,
\*(lqcm=^T%.%.\*(rq.
Terminals that use \*(lq%.\*(rq need to be able to
backspace the cursor
.RB ( le )
and to move the cursor up one line on the screen
.RB ( up ).
This is necessary because it is not always safe to transmit
.BR \en ,
.BR ^D ,
and
.BR \er ,
as the system may change or discard them.
(Programs using
.I termcap\^
must set terminal modes so that tabs are not expanded, so
.B \et
is safe to send.
This turns out to be essential for the Ann Arbor 4080.)
.PP
A final example is the Lear Siegler \s-1ADM\s0\-3a,
which offsets row and column
by a blank character, thus \*(lqcm=\eE=%+ %+ \*(rq.
.PP
Row or column absolute cursor addressing
can be given as single parameter capabilities
.B ch
(horizontal position absolute) and
.B cv
(vertical position absolute).
Sometimes these are shorter than the more general two-parameter sequence
(as with the Hewlett-Packard 2645) and can be used in preference to
.BR cm .
If there are parameterized local motions
.RI ( e.g. ,
move
.I n\^
positions to the right)
these can be given as
.BR DO ,
.BR LE ,
.BR RI ,
and
.B UP
with a single parameter indicating how many positions to move.
These are primarily useful if the terminal does not have
.BR cm ,
such as the Tektronix 4025.
.br
.ne 5
.PP
.B Cursor Motions
.PP
If the terminal has a fast way to home the cursor
(to the very upper left corner of the screen), this can be given as
.BR ho .
Similarly, a fast way of getting to the lower left-hand corner
can be given as
.BR ll ;
this may involve going up with
.B up
from the home position,
but a program should never do this itself (unless
.B ll
does), because it can
make no assumption about the effect of moving up from the home position.
Note that the home position is the same as
cursor address (0,0): to the top left corner of the screen, not of memory.
(Therefore, the \*(lq\eEH\*(rq sequence on Hewlett-Packard terminals
cannot be used for
.BR ho .)
.br
.ne 5
.PP
.B Area Clears
.PP
If the terminal can clear from the current position to the end of the
line, leaving the cursor where it is, this should be given as
.BR ce .
If the terminal can clear from the current position to the end of the
display, this should be given as
.BR cd .
.B cd
must only be invoked from the first column of a line.
(Therefore,
it can be simulated by a request to delete a large number of lines,
if a true
.B cd
is not available.)
.br
.ne 5
.PP
.B Insert/Delete Line
.PP
If the terminal can open a new blank line
before the line containing the cursor,
this should be given as
.BR al ;
this must be invoked only from the first
position of a line.
The cursor must then appear at the left of the newly blank line.
If the terminal can delete the line that the cursor is on, this
should be given as
.BR dl ;
this must only be used from the first position on
the line to be deleted.
Versions of
.B al
and
.B dl
which take a single parameter
and insert or delete that many lines
can be given as
.B AL
and
.BR DL .
If the terminal has a settable scrolling region
(like the VT100),
the command to set this can be described with the
.B cs
capability,
which takes two parameters: the top and bottom lines of the scrolling region.
The cursor position is, alas, undefined after using this command.
It is possible to get the effect of insert or delete line
using this command \(em the
.B sc
and
.B rc
(save and restore cursor) commands are also useful.
Inserting lines at the top or bottom of the screen can also be done using
.B sr
or
.B sf
on many terminals without a true insert/delete line,
and is often faster even on terminals with those features.
.PP
If the terminal has the ability to define a window as part of memory
which all commands affect, it should be given as the parameterized string
.BR wi .
The four parameters are the starting and ending lines in memory
and the starting and ending columns in memory, in that order.
(This
.I terminfo\^
capability is described for completeness.
It is unlikely that any
.IR termcap\^ -using
program will support it.)
.PP
If the terminal can retain display memory above the screen, then the
.B da
capability should be given;
if display memory can be retained
below, then
.B db
should be given.
These indicate
that deleting a line or scrolling may bring non-blank lines up from below
or that scrolling back with
.B sr
may bring down non-blank lines.
.br
.ne 5
.PP
.B Insert/Delete Character
.PP
There are two basic kinds of intelligent terminals with respect to
insert/delete character that can be described using
.IR termcap\^ .
The most common insert/delete character operations affect only the characters
on the current line and shift characters off the end of the line rigidly.
Other terminals, such as the Concept\-100 and the Perkin Elmer Owl, make
a distinction between typed and untyped blanks on the screen, shifting
upon an insert or delete only to an untyped blank on the screen which is
either eliminated or expanded to two untyped blanks.
You can determine
the kind of terminal you have by clearing the screen then typing
text separated by cursor motions.
Type \*(lqabc\ \ \ \ def\*(rq using local
cursor motions (not spaces) between the \*(lqabc\*(rq and the \*(lqdef\*(rq.
Then position the cursor before the \*(lqabc\*(rq and put the terminal in insert
mode.
If typing characters causes the rest of the line to shift
rigidly and characters to fall off the end, then your terminal does
not distinguish between blanks and untyped positions.
If the \*(lqabc\*(rq
shifts over to the \*(lqdef\*(rq which then move together around the end of the
current line and onto the next as you insert, then you have the second type of
terminal and should give the capability \fBin\fP, which stands for
\*(lqinsert null\*(rq.
While these are two logically separate attributes
(one line
.I vs.
multi-line insert mode,
and special treatment of untyped spaces),
we have seen no terminals whose insert
mode cannot be described with the single attribute.
.PP
.I Termcap\^
can describe both terminals that have an insert mode and terminals
that send a simple sequence to open a blank position on the current line.
Give as
.B im
the sequence to get into insert mode.
Give as
.B ei
the sequence to leave insert mode.
Now give as
.B ic
any sequence that needs to be sent just before
each character to be inserted.
Most terminals with a true insert mode
will not give
.BR ic ;
terminals that use a sequence to open a screen
position should give it here.
(If your terminal has both,
insert mode is usually preferable to
.BR ic .
Do not give both unless the terminal actually requires both to be used
in combination.)
If post-insert padding is needed, give this as a number of milliseconds
in
.B ip
(a string option).
Any other sequence that may need to be
sent after insertion of a single character can also be given in
.BR ip .
If your terminal needs to be placed into an `insert mode'
and needs a special code preceding each inserted character,
then both
.BR im / ei
and
.B ic
can be given, and both will be used.
The
.B IC
capability, with one parameter
.IR n\^ ,
will repeat the effects of
.B ic
.I n\^
times.
.PP
It is occasionally necessary to move around while in insert mode
to delete characters on the same line
.RI ( e.g. ,
if there is a tab after
the insertion position).
If your terminal allows motion while in
insert mode, you can give the capability
.B mi
to speed up inserting
in this case.
Omitting
.B mi
will affect only speed.
Some terminals
(notably Datamedia's) must not have
.B mi
because of the way their
insert mode works.
.PP
Finally, you can specify
.B dc
to delete a single character,
.B DC
with one parameter
.I n\^
to delete
.I n\^
characters,
and delete mode by giving
.B dm
and
.B ed
to enter and exit delete mode
(which is any mode the terminal needs to be placed in for
.B dc
to work).
.br
.ne 5
.PP
.B Highlighting, Underlining, and Visible Bells
.PP
If your terminal has one or more kinds of display attributes,
these can be represented in a number of different ways.
You should choose one display form as
.IR "standout mode" ,
representing a good high-contrast, easy-on-the-eyes format
for highlighting error messages and other attention getters.
(If you have a choice, reverse video plus half-bright is good,
or reverse video alone.)
The sequences to enter and exit standout mode
are given as
.B so
and
.BR se ,
respectively.
If the code to change into or out of standout
mode leaves one or even two blank spaces or garbage characters on the screen,
as the TVI 912 and Teleray 1061 do,
then
.B sg
should be given to tell how many characters are left.
.PP
Codes to begin underlining and end underlining can be given as
.B us
and
.BR ue ,
respectively.
Underline mode change garbage is specified by
.BR ug ,
similar to
.BR sg .
If the terminal has a code to underline the current character and move
the cursor one position to the right, 
such as the Microterm Mime,
this can be given as
.BR uc .
.PP
Other capabilities to enter various highlighting modes include
.B mb
(blinking),
.B md
(bold or extra bright),
.B mh
(dim or half-bright),
.B mk
(blanking or invisible text),
.B mp
(protected),
.B mr
(reverse video),
.B me
(turn off
.I all
attribute modes),
.B as
(enter alternate character set mode), and
.B ae
(exit alternate character set mode).
Turning on any of these modes singly may or may not turn off other modes.
.PP
If there is a sequence to set arbitrary combinations of mode,
this should be given as
.B sa
(set attributes), taking 9 parameters.
Each parameter is either 0 or 1,
as the corresponding attributes is on or off.
The 9 parameters are, in order: standout, underline, reverse, blink,
dim, bold, blank, protect, and alternate character set.
Not all modes need be supported by
.BR sa ,
only those for which corresponding attribute commands exist.
(It is unlikely that a
.IR termcap\^ -using
program will support this capability, which is defined for compatibility
with
.IR terminfo\^ .)
.PP
Terminals with the \*(lqmagic cookie\*(rq glitches
.RB ( sg
and
.BR ug ),
rather than maintaining extra attribute bits for each character cell,
instead deposit special \*(lqcookies\*(rq,
or \*(lqgarbage characters\*(rq,
when they receive mode-setting sequences,
which affect the display algorithm.
.PP
Some terminals,
such as the Hewlett-Packard 2621,
automatically leave standout
mode when they move to a new line or when the cursor is addressed.
Programs using standout mode
should exit standout mode on such terminals
before moving the cursor or sending a newline.
On terminals where this is not a problem,
the
.B ms
capability should be present
to say that this overhead is unnecessary.
.PP
If the terminal has
a way of flashing the screen to indicate an error quietly
(a bell replacement),
this can be given as
.BR vb ;
it must not move the cursor.
.PP
If the cursor needs to be made more visible than normal
when it is not on the bottom line
(to change, for example, a non-blinking underline into an easier-to-find
block or blinking underline),
give this sequence as
.BR vs .
If there is a way to make the cursor completely invisible, give that as
.BR vi .
The capability
.BR ve ,
which undoes the effects of both of these modes,
should also be given.
.PP
If your terminal correctly displays underlined characters
(with no special codes needed)
even though it does not overstrike,
then you should give the capability
.BR ul .
If overstrikes are erasable with a blank,
this should be indicated by giving
.BR eo .
.br
.ne 5
.PP
.B Keypad
.PP
If the terminal has a keypad that transmits codes when the keys are pressed,
this information can be given.
Note that it is not possible to handle
terminals where the keypad only works in local mode
(this applies, for example, to the unshifted Hewlett-Packard 2621 keys).
If the keypad can be set to transmit or not transmit,
give these codes as
.B ks
and
.BR ke .
Otherwise the keypad is assumed to always transmit.
The codes sent by the left-arrow, right-arrow, up-arrow, down-arrow,
and home keys can be given as
.BR kl ,
.BR kr ,
.BR ku ,
.BR kd ,
and
.BR kh ,
respectively.
If there are function keys such as f0, f1, ..., f9, the codes they send
can be given as
.BR k0 ,
.BR k1 , "" ...,
.BR k9 .
If these keys have labels other than the default f0 through f9, the labels
can be given as
.BR l0 ,
.BR l1 , "" ...,
.BR l9 .
The codes transmitted by certain other special keys can be given:
.B kH
(home down),
.B kb
(backspace),
.B ka
(clear all tabs),
.B kt
(clear the tab stop in this column),
.B kC
(clear screen or erase),
.B kD
(delete character),
.B kL
(delete line),
.B kM
(exit insert mode),
.B kE
(clear to end of line),
.B kS
(clear to end of screen),
.B kI
(insert character or enter insert mode),
.B kA
(insert line),
.B kN
(next page),
.B kP
(previous page),
.B kF
(scroll forward/down),
.B kR
(scroll backward/up), and
.B kT
(set a tab stop in this column).
In addition, if the keypad has a 3 by 3 array of keys
including the four arrow keys, then the other five keys can be given as
.BR K1 ,
.BR K2 ,
.BR K3 ,
.BR K4 ,
and
.BR K5 .
These keys are useful when the effects of a 3 by 3 directional pad are needed.
The obsolete
.B ko
capability formerly used to describe \*(lqother\*(rq function keys has been
completely supplanted by the above capabilities.
.PP
The
.B ma
entry is also used to indicate arrow keys on terminals that have
single-character arrow keys.
It is obsolete but still in use in
version 2 of
.I vi\^
which must be run on some minicomputers due to
memory limitations.
This field is redundant with
.BR kl ,
.BR kr ,
.BR ku ,
.BR kd ,
and
.BR kh .
It consists of groups of two characters.
In each group, the first character is what an arrow key sends, and the
second character is the corresponding
.I vi\^
command.
These commands are
.B h
for
.BR kl ,
.B j
for
.BR kd ,
.B k
for
.BR ku ,
.B l
for
.BR kr ,
and
.B H
for
.BR kh .
For example, the Mime would have \*(lqma=^Hh^Kj^Zk^Xl\*(rq
indicating arrow keys left (^H), down (^K), up (^Z), and right (^X).
(There is no home key on the Mime.)
.br
.ne 5
.PP
.B Tabs and Initialization
.PP
If the terminal needs to be in a special mode when running
a program that uses these capabilities,
the codes to enter and exit this mode can be given as
.B ti
and
.BR te .
This arises, for example, from terminals like the Concept with more than
one page of memory.
If the terminal has only memory-relative cursor addressing and not
screen-relative cursor addressing,
a screen-sized window must be fixed into
the display for cursor addressing to work properly.
This is also used for the Tektronix 4025, where
.B ti
sets the command character to be the one used by
.IR termcap\^ .
.PP
Other capabilities
include
.BR is ,
an initialization string for the terminal,
and
.BR if ,
the name of a file containing long initialization strings.
These strings are expected to set the terminal into modes
consistent with the rest of the
.I termcap\^
description.
They are normally sent to the terminal by the
.I tset\^
program each time the user logs in.
They will be printed in the following order:
.BR is ;
setting tabs using
.B ct
and
.BR st ;
and finally
.BR if .
.RI ( Terminfo\^
uses
.B i1-i2
instead of
.B is
and runs the program
.B iP
and prints
.B i3
after the other initializations.)
A pair of sequences that does a harder reset from a totally unknown state
can be analogously given as
.B rs
and
.BR if .
These strings are output by the
.I reset\^
program, which is used when the terminal gets into a wedged state.
.RI ( Terminfo\^
uses
.B r1-r3
instead of
.BR rs .)
Commands are normally placed in
.B rs
and
.B rf
only if they produce annoying effects on the screen and are not necessary
when logging in.
For example, the command to set the VT100 into 80-column mode
would normally be part of
.BR is ,
but it causes an annoying glitch of the screen and is not normally needed
since the terminal is usually already in 80-column mode.
.PP
If the terminal has hardware tabs,
the command to advance to the next tab stop can be given as
.B ta
(usually
.BR ^I ).
A \*(lqbacktab\*(rq command which moves leftward to the previous tab stop
can be given as
.BR bt .
By convention,
if the terminal driver modes indicate that tab stops are being expanded
by the computer rather than being sent to the terminal,
programs should not use
.B ta
or
.B bt
even if they are present,
since the user may not have the tab stops properly set.
If the terminal has hardware tabs that are initially set every
.I n\^
positions when the terminal is powered up, then the numeric parameter
.B it
is given, showing the number of positions between tab stops.
This is normally used by the
.I tset\^
command to determine whether to set the driver mode for hardware tab
expansion, and whether to set the tab stops.
If the terminal has tab stops that can be saved in nonvolatile memory, the
.I termcap\^
description can assume that they are properly set.
.PP
If there are commands to set and clear tab stops, they can be given as
.B ct
(clear all tab stops) and
.B st
(set a tab stop in the current column of every row).
If a more complex sequence is needed to set the tabs than can be
described by this, the sequence can be placed in
.B is
or
.BR if .
.br
.ne 5
.PP
.B Delays
.PP
Certain capabilities control padding in the terminal driver.
These are primarily needed by hardcopy terminals and are used by the
.I tset\^
program to set terminal driver modes appropriately.
Delays embedded in the capabilities
.BR cr ,
.BR sf ,
.BR le ,
.BR ff ,
and
.B ta
will cause the appropriate delay bits to be set in the terminal driver.
If
.B pb
(padding baud rate) is given, these values can be ignored at baud rates
below the value of
.BR pb .
For 4.2BSD
.IR tset\^ ,
the delays are given as numeric capabilities
.BR dC ,
.BR dN ,
.BR dB ,
.BR dF ,
and
.BR dT
instead.
.br
.ne 5
.PP
.B Miscellaneous
.PP
If the terminal requires other than a \s-2NUL\s0 (zero) character as a pad,
this can be given as
.BR pc .
Only the first character of the
.B pc
string is used.
.PP
If the terminal has commands to save and restore the position of the
cursor, give them as
.B sc
and
.BR rc .
.PP
If the terminal has an extra \*(lqstatus line\*(rq that is not normally used by
software, this fact can be indicated.
If the status line is viewed as an extra line below the bottom line,
then the capability
.B hs
should be given.
Special strings to go to a position in the status line and to return
from the status line can be given as
.B ts
and
.BR fs .
.RB ( fs
must leave the cursor position in the same place that it was before
.BR ts .
If necessary, the
.B sc
and
.B rc
strings can be included in
.B ts
and
.B fs
to get this effect.)
The capability
.B ts
takes one parameter, which is the column number of the status line
to which the cursor is to be moved.
If escape sequences and other special commands such as tab work while in
the status line, the flag
.B es
can be given.
A string that turns off the status line (or otherwise erases its contents)
should be given as
.BR ds .
The status line is normally assumed to be the same width as the
rest of the screen,
.IR i.e. ,
.BR co .
If the status line is a different width (possibly because the terminal
does not allow an entire line to be loaded), then its width in columns
can be indicated with the numeric parameter
.BR ws .
.PP
If the terminal can move up or down half a line, this can be
indicated with
.B hu
(half-line up) and
.B hd
(half-line down).
This is primarily useful for superscripts and subscripts on hardcopy
terminals.
If a hardcopy terminal can eject to the next page (form feed),
give this as
.B ff
(usually
.BR ^L ).
.PP
If there is a command to repeat a given character a given number of times
(to save time transmitting a large number of identical characters),
this can be indicated with the parameterized string
.BR rp .
The first parameter is the character to be repeated and the second is
the number of times to repeat it.
(This is a
.I terminfo\^
feature that is unlikely to be supported by a program that uses
.IR termcap\^ .)
.PP
If the terminal has a settable command character, such as the
Tektronix 4025, this can be indicated with
.BR CC .
A prototype command character is chosen which is used in all capabilities.
This character is given in the
.B CC
capability to identify it.
The following convention is supported on some UNIX systems:
The environment is to be searched for a
.B
.SM CC
variable,
and if found,
all occurrences of the prototype character are replaced by the character
in the environment variable.
This use of the
.B
.SM CC
environment variable
is a very bad idea, as it conflicts with
.IR make\^ (1).
.PP
Terminal descriptions that do not represent a specific kind of known
terminal, such as
.IR switch\^ ,
.IR dialup\^ ,
.IR patch\^ ,
and
.IR network\^ ,
should include the
.B gn
(generic) capability so that programs can complain that they do not know
how to talk to the terminal.
(This capability does not apply to
.I virtual\^
terminal descriptions for which the escape sequences are known.)
.PP
If the terminal uses xoff/xon (\s-2DC3\s0/\s-2DC1\s0)
handshaking for flow control, give
.BR xo .
Padding information should still be included so that routines can make
better decisions about costs, but actual pad characters will not be
transmitted.
.PP
If the terminal has a \*(lqmeta key\*(rq which acts as a shift key, setting the
8th bit of any character transmitted, then this fact can be indicated with
.BR km .
Otherwise, software will assume that the 8th bit is parity and it will
usually be cleared.
If strings exist to turn this \*(lqmeta mode\*(rq on and off, they can be given as
.B mm
and
.BR mo .
.PP
If the terminal has more lines of memory than will fit on the screen at once,
the number of lines of memory can be indicated with
.BR lm .
An explicit value of 0 indicates that the number of lines is not fixed,
but that there is still more memory than fits on the screen.
.PP
If the terminal is one of those supported by the UNIX system virtual
terminal protocol, the terminal number can be given as
.BR vt .
.PP
Media copy strings which control an auxiliary printer
connected to the terminal can be given as
.BR ps :
print the contents of the screen;
.BR pf :
turn off the printer; and
.BR po :
turn on the printer.
When the printer is on, all text sent to the terminal will be sent to the
printer.
It is undefined whether the text is also displayed on the terminal screen
when the printer is on.
A variation
.B pO
takes one parameter and leaves the printer on for as many characters as the
value of the parameter, then turns the printer off.
The parameter should not exceed 255.
All text, including
.BR pf ,
is transparently passed to the printer while
.B pO
is in effect.
.PP
Strings to program function keys can be given as
.BR pk ,
.BR pl ,
and
.BR px .
Each of these strings takes two parameters: the function key number
to program (from 0 to 9) and the string to program it with.
Function key numbers out of this range may program undefined keys
in a terminal-dependent manner.
The differences among the capabilities are that
.B pk
causes pressing the given key to be the same as the user typing the given
string;
.B pl
causes the string to be executed by the terminal in local mode;
and
.B px
causes the string to be transmitted to the computer.
Unfortunately, due to lack of a definition for string parameters in
.IR termcap\^ ,
only
.I terminfo\^
supports these capabilities.
.br
.ne 5
.PP
.B Glitches and Braindamage
.PP
Hazeltine terminals, which do not allow `~' characters to be displayed,
should indicate
.BR hz .
.PP
The
.B nc
capability, now obsolete, formerly indicated Datamedia terminals,
which echo
.B \er \en
for
carriage return then ignore a following linefeed.
.PP
Terminals that ignore a linefeed immediately after an
.B am
wrap, such as the Concept, should indicate
.BR xn .
.PP
If
.B ce
is required to get rid of standout
(instead of merely writing normal text on top of it),
.B xs
should be given.
.PP
Teleray terminals, where tabs turn all characters moved over to blanks,
should indicate
.B xt
(destructive tabs).
This glitch is also taken to mean that it is not possible
to position the cursor on top of a \*(lqmagic cookie\*(rq, and that
to erase standout mode it is necessary to use delete and insert line.
.PP
The Beehive Superbee, which is unable to correctly transmit the
\s-2ESC\s0 or ^C characters, has
.BR xb ,
indicating that the \*(lqf1\*(rq key is used for \s-2ESC\s0 and \*(lqf2\*(rq for ^C.
(Only certain Superbees have this problem, depending on the ROM.)
.PP
Other specific terminal problems may be corrected by adding more
capabilities of the form \fBx\fIx\^\fP.
.br
.ne 5
.PP
.B Similar Terminals
.PP
If there are two very similar terminals,
one can be defined as being just like the other with certain exceptions.
The string capability
.B tc
can be given
with the name of the similar terminal.
This capability must be
.IR last\^ ,
and the combined length of the entries
must not exceed 1024.
The capabilities given before
.B tc
override those in the terminal type invoked by
.BR tc .
A capability can be canceled by placing
.B xx@
to the left of the
.B tc
invocation, where
.I xx\^
is the capability.
For example, the entry
.PP
	hn\||\|2621\-nl:ks@:ke@:tc=2621:
.PP
defines a \*(lq2621\-nl\*(rq that does not have the
.B ks
or
.B ke
capabilities,
hence does not turn on the function key labels when in visual mode.
This is useful for different modes for a terminal, or for different
user preferences.
.SH AUTHOR
William Joy
.br
Mark Horton added underlining and keypad support
.SH FILES
.DT
/etc/termcap	file containing terminal descriptions
.SH SEE ALSO
ex(1), more(1), tset(1), ul(1), vi(1), curses(3X), printf(3S),
termcap(3X), term(7)
.SH "CAVEATS AND BUGS"
.B Note:
.I termcap\^
was replaced by
.I terminfo\^
in UNIX System V Release 2.0.
The transition will be relatively painless if capabilities flagged as
\*(lqobsolete\*(rq are avoided.
.PP
Lines and columns are now stored by the kernel as well as in the termcap
entry.
Most programs now use the kernel information primarily; the information
in this file is used only if the kernel does not have any information.
.PP
.I Vi\^
allows only 256 characters for string capabilities, and the routines
in 
.IR termlib\^ (3)
do not check for overflow of this buffer.
The total length of a single entry (excluding only escaped newlines)
may not exceed 1024.
.PP
Not all programs support all entries.
