.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)talkd.8c	6.2 (Berkeley) 5/21/86
.\"
.TH TALKD 8C "May 21, 1986"
.UC 6
.SH NAME
talkd \- remote user communication server
.SH SYNOPSIS
.B /etc/talkd
.SH DESCRIPTION
.I Talkd
is the server that notifies a user that somebody else wants to
initiate a conversation.
It acts a repository of invitations, responding to requests
by clients wishing to rendezvous to hold a conversation.
In normal operation, a client, the caller,
initiates a rendezvous by sending a CTL_MSG to the server of
type LOOK_UP (see
.RI < protocols/talkd.h >).
This causes the server to search its invitation
tables to check if an invitation currently exists for the caller
(to speak to the callee specified in the message).
If the lookup fails,
the caller then sends an ANNOUNCE message causing the server to
broadcast an announcement on the callee's login ports requesting contact.
When the callee responds, the local server uses the
recorded invitation to respond with the appropriate rendezvous
address and the caller and callee client programs establish a
stream connection through which the conversation takes place.
.SH SEE ALSO
talk(1), write(1)
