.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)savecore.8	6.3 (Berkeley) 5/24/86
.\"
.TH SAVECORE 8 "May 24, 1986"
.UC 4
.SH NAME
savecore \- save a core dump of the operating system
.SH SYNOPSIS
.B /etc/savecore
.I dirname
[
.I system
]
.SH DESCRIPTION
.I Savecore
is meant to be called near the end of the /etc/rc file.  Its function
is to save the core dump of the system (assuming one was made) and to
write a reboot message in the shutdown log.
.PP
Savecore checks the core dump to be certain it corresponds with the
current running unix.  If it does it saves the core image in the file
.IR dirname /vmcore.n
and its brother, the namelist,
.IR dirname /vmunix.n
The trailing ".n" in the pathnames is replaced by a number which grows
every time
.I savecore
is run in that directory.
.PP
Before savecore writes out a core image, it reads a number from the file
.IR dirname /minfree.
If the number of free kilobytes on the filesystem which contains
.I dirname
is less than the number obtained from the minfree file,
the core dump is not saved.
If the minfree file does not exist, savecore always writes out the core
file (assuming that a core dump was taken).
.PP
.I Savecore
also logs a reboot message using facility LOG_AUTH (see
.IR syslog (3))
If the system crashed as a result of a panic,
.I savecore
logs the panic string too.
.PP
If the core dump was from a system other than /vmunix, the name
of that system must be supplied as
.IR sysname .
.SH FILES
.DT
/vmunix		current UNIX
.SH BUGS
Can be fooled into thinking a core dump is the wrong size.
