.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sa.8	6.2 (Berkeley) 7/29/85
.\"
.TH SA 8 "July 29, 1985"
.UC 4
.SH NAME
sa, accton \- system accounting
.SH SYNOPSIS
.B /etc/sa
[
.B \-abcdDfijkKlnrstuv
] [
.B \-S
savacctfile ] [
.B \-U
usracctfile ] [ file ]
.PP
.B /etc/accton 
[ file ]
.SH DESCRIPTION
With an argument naming an existing
.I file,
.I accton
causes system accounting information for
every process executed to be placed at the end of the file.
If no argument is given, accounting is turned off.
.PP
.I Sa
reports on, cleans up, and generally maintains accounting files.
.PP
.I Sa
is able to condense the information in
.I /usr/adm/acct
into a summary file
.I /usr/adm/savacct
which contains a count of the
number of times each command was called and the time resources consumed.
This condensation is desirable because on a large system
.I /usr/adm/acct
can grow by 100 blocks per day.
The summary file is normally read before the accounting file,
so the reports include all available information.
.PP
If a file name is given as the last argument, that file will be treated
as the accounting file;
.I /usr/adm/acct
is the default.
.PP
Output fields are labeled: \*(lqcpu\*(rq for the sum of user+system time
(in minutes), \*(lqre\*(rq for real time (also in minutes),
\*(lqk\*(rq for cpu-time averaged core usage (in 1k units),
\*(lqavio\*(rq for average number of i/o operations per execution.
With options fields labeled \*(lqtio\*(rq for total i/o operations,
\*(lqk*sec\*(rq for cpu storage integral (kilo-core seconds), \*(lqu\*(rq and \*(lqs\*(rq
for user and system cpu time alone (both in minutes) will sometimes appear.
.PP
There are near a googol of options:
.PP
.TP
a
Print all command names, even those containing unprintable characters
and those used only once.  By default, those are placed under the
name `***other.'
.TP
b
Sort output by sum of user and system time divided by number of calls.
Default sort is by sum of user and system times.
.TP
c
Besides total user, system, and real time for each command print percentage
of total time over all commands.
.TP
d
Sort by average number of disk i/o operations.
.TP
D
Print and sort by total number of disk i/o operations.
.TP
f
Force no interactive threshold compression with \-v flag.
.TP
i
Don't read in summary file.
.TP
j
Instead of total minutes time for each category, give seconds per call.
.TP
k
Sort by cpu-time average memory usage.
.TP
K
Print and sort by cpu-storage integral.
.TP
l
Separate system and user time; normally they are combined.
.TP
m
Print number of processes and number of CPU minutes for each user.
.TP
n
Sort by number of calls.
.TP
r
Reverse order of sort.
.TP
s
Merge accounting file into summary file
.I /usr/adm/savacct
when done.
.TP
t
For each command report ratio of real time to the sum of user and system times.
.TP
u
Superseding all other flags, print for each command in the accounting file the
user ID and command name.
.TP
v
Followed by a number
.I n,
types the name of each command used
.I n
times or fewer.
Await a reply from the terminal; if it begins with `y', add the command to
the category `**junk**.' This is used to strip out garbage.
.TP
S
The following filename is used as the command summary file instead of
.I /usr/adm/savacct.
.TP
U
The following filename is used instead of
.I /usr/adm/usracct
to accumulate the per-user statistics printed by the \-m option.
.dt
.SH FILES
.ta 2i
/usr/adm/acct	raw accounting
.br
/usr/adm/savacct	summary
.br
/usr/adm/usracct	per-user summary
.SH "SEE ALSO"
ac(8), acct(2)
.SH BUGS
The number of options to this program is absurd.
