.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rexecd.8c	6.2 (Berkeley) 5/9/86
.\"
.TH REXECD 8C "May 9, 1986"
.UC 5
.SH NAME
rexecd \- remote execution server
.SH SYNOPSIS
.B /etc/rexecd
.SH DESCRIPTION
.I Rexecd
is the server for the 
.IR rexec (3X)
routine.  The server provides remote execution facilities
with authentication based on user names and
passwords.
.PP
.I Rexecd
listens for service requests at the port indicated in
the ``exec'' service specification; see
.IR services (5).
When a service request is received the following protocol
is initiated:
.IP 1)
The server reads characters from the socket up
to a null (`\e0') byte.  The resultant string is
interpreted as an ASCII number, base 10.
.IP 2)
If the number received in step 1 is non-zero,
it is interpreted as the port number of a secondary
stream to be used for the 
.BR stderr .
A second connection is then created to the specified
port on the client's machine.
.IP 3)
A null terminated user name of at most 16 characters
is retrieved on the initial socket.
.IP 4)
A null terminated, unencrypted password of at most
16 characters is retrieved on the initial socket.  
.IP 5)
A null terminated command to be passed to a
shell is retrieved on the initial socket.  The length of
the command is limited by the upper bound on the size of
the system's argument list.  
.IP 6)
.I Rexecd
then validates the user as is done at login time
and, if the authentication was successful, changes
to the user's home directory, and establishes the user
and group protections of the user.
If any of these steps fail the connection is
aborted with a diagnostic message returned.
.IP 7)
A null byte is returned on the initial socket
and the command line is passed to the normal login
shell of the user.  The
shell inherits the network connections established
by
.IR rexecd .
.SH DIAGNOSTICS
Except for the last one listed below,
all diagnostic messages are returned on the initial socket,
after which any network connections are closed.
An error is indicated by a leading byte with a value of
1 (0 is returned in step 7 above upon successful completion
of all the steps prior to the command execution).
.PP
.B ``username too long''
.br
The name is
longer than 16 characters.
.PP
.B ``password too long''
.br
The password is longer than 16 characters.
.PP
.B ``command too long ''
.br
The command line passed exceeds the size of the argument
list (as configured into the system).
.PP
.B ``Login incorrect.''
.br
No password file entry for the user name existed.
.PP
.B ``Password incorrect.''
.br
The wrong was password supplied.
.PP
.B ``No remote directory.''
.br
The 
.I chdir
command to the home directory failed.
.PP
.B ``Try again.''
.br
A
.I fork
by the server failed.
.PP
.B ``<shellname>: ...''
.br
The user's login shell could not be started.
This message is returned
on the connection associated with the
.BR stderr ,
and is not preceded by a flag byte.
.SH SEE ALSO
rexec(3X)
.SH BUGS
Indicating ``Login incorrect'' as opposed to ``Password incorrect''
is a security breach which allows people to probe a system for users
with null passwords.
.PP
A facility to allow all data and password exchanges to be encrypted should be
present.
