.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)restore.8	6.6 (Berkeley) 7/31/87
.\"
.TH RESTORE 8 "July 31, 1987"
.UC 4
.SH NAME
restore \- incremental file system restore
.SH SYNOPSIS
.B /etc/restore
key [ name ... ]
.SH DESCRIPTION
.PP
.I Restore
reads tapes dumped with the
.IR dump (8)
command.
Its actions are controlled by the
.I key
argument.
The
.I key
is a string of characters containing
at most one function letter and possibly
one or more function modifiers.
Other arguments to the command are file or directory
names specifying the files that are to be restored.
Unless the
.B h
key is specified (see below),
the appearance of a directory name refers to
the files and (recursively) subdirectories of that directory.
.PP
The function portion of
the key is specified by one of the following letters:
.TP 5n
.B  r
The tape
is read and loaded into the current directory.
This should not be done lightly; the
.B r
key should only be used to restore
a complete dump tape onto a clear file system
or to restore an incremental dump tape after a full level zero restore.
Thus
.IP "" 5n
	/etc/newfs /dev/rrp0g eagle
.br
	/etc/mount /dev/rp0g /mnt
.br
	cd /mnt
.br
	restore r
.IP "" 5n
is a typical sequence to restore a complete dump.
Another
.I restore
can be done to get an incremental dump
in on top of this.
Note that 
.I restore
leaves a file 
.I restoresymtable
in the root directory to pass information between incremental
restore passes.
This file should be removed when the last incremental tape has been
restored.
.br
A
.IR dump (8)
followed by a
.IR newfs (8)
and a
.I restore
is used to change the size of a file system.
.TP 5n
.B  R
.I Restore
requests a particular tape of a multi volume set on which to restart
a full restore
(see the
.B r
key above).
This allows
.I restore
to be interrupted and then restarted.
.TP 5n
.B  x
The named files are extracted from the tape.
If the named file matches a directory whose contents 
had been written onto the tape,
and the
.B h
key is not specified,
the directory is recursively extracted.
The owner, modification time,
and mode are restored (if possible).
If no file argument is given,
then the root directory is extracted,
which results in the entire content of the
tape being extracted,
unless the
.B h
key has been specified.
.TP 5n
.B  t
The names of the specified files are listed if they occur
on the tape.
If no file argument is given,
then the root directory is listed,
which results in the entire content of the
tape being listed,
unless the
.B h
key has been specified.
Note that the
.B t
key replaces the function of the old
.I dumpdir
program.
.TP 5n
.B  i
This mode allows interactive restoration of files from a dump tape.
After reading in the directory information from the tape,
.I restore
provides a shell like interface that allows the user to move
around the directory tree selecting files to be extracted.
The available commands are given below;
for those commands that require an argument,
the default is the current directory.
.IP "" 10n
.ti -5n
.br
.B ls
[arg] \-
List the current or specified directory.
Entries that are directories are appended with a ``/''.
Entries that have been marked for extraction are prepended with a ``*''.
If the verbose key is set the inode number of each entry is also listed.
.ti -5n
.sp
.B cd
arg \-
Change the current working directory to the specified argument.
.ti -5n
.sp
.B pwd
\-
Print the full pathname of the current working directory.
.ti -5n
.sp
.B add
[arg] \-
The current directory or specified argument is added to the list of
files to be extracted.
If a directory is specified, then it and all its descendents are
added to the extraction list
(unless the
.B h
key is specified on the command line).
Files that are on the extraction list are prepended with a ``*''
when they are listed by 
.BR ls .
.ti -5n
.sp
.B delete
[arg] \-
The current directory or specified argument is deleted from the list of
files to be extracted.
If a directory is specified, then it and all its descendents are
deleted from the extraction list
(unless the
.B h
key is specified on the command line).
The most expedient way to extract most of the files from a directory 
is to add the directory to the extraction list and then delete
those files that are not needed.
.ti -5n
.sp
.B extract
\-
All the files that are on the extraction list are extracted
from the dump tape.
.I Restore
will ask which volume the user wishes to mount.
The fastest way to extract a few files is to
start with the last volume, and work towards the first volume.
.ti -5n
.sp
.B setmodes
\-
All the directories that have been added to the extraction list
have their owner, modes, and times set;
nothing is extracted from the tape.
This is useful for cleaning up after a restore has been prematurely aborted.
.ti -5n
.sp
.B verbose
\-
The sense of the 
.B v
key is toggled.
When set, the verbose key causes the 
.B ls
command to list the inode numbers of all entries.
It also causes
.I restore
to print out information about each file as it is extracted.
.ti -5n
.sp
.B help
\-
List a summary of the available commands.
.ti -5n
.sp
.B quit
\-
Restore immediately exits,
even if the extraction list is not empty.
.sp
.PP
The following characters may be used in addition to the letter
that selects the function desired.
.TP 5n
.B b
The next argument to 
.I restore
is used as the block size of the tape (in kilobytes).
If the \fB-b\fP option is not specified,
.I restore
tries to determine the tape block size dynamically.
.TP 5n
.B f
The next argument to 
.I restore
is used as the name of the archive instead
of /dev/rmt?. 
If the name of the file is ``\-'',
.I restore 
reads from standard input.
Thus,
.IR dump (8)
and
.I restore
can be used in a pipeline to dump and restore a file system
with the command
.IP "" 5n
	dump 0f - /usr | (cd /mnt; restore xf -)
.TP 5n
.B  v
Normally
.I restore
does its work silently.
The
.B v
(verbose)
key causes it to type the name of each file it treats
preceded by its file type.
.TP 5n
.B y
.I Restore
will not ask whether it should abort the restore if gets a tape error.
It will always try to skip over the bad tape block(s) and continue as
best it can.
.TP 5n
.B m
.I Restore
will extract by inode numbers rather than by file name.
This is useful if only a few files are being extracted,
and one wants to avoid regenerating the complete pathname
to the file.
.TP 5n
.B h
.I Restore
extracts the actual directory, 
rather than the files that it references.
This prevents hierarchical restoration of complete subtrees
from the tape.
.TP 5n
.B s
The next argument to
.I restore
is a number which
selects the file on a multi-file dump tape.  File numbering
starts at 1.
.SH DIAGNOSTICS
Complaints about bad key characters.
.PP
Complaints if it gets a read error.
If 
.B y
has been specified, or the user responds ``y'',
.I restore
will attempt to continue the restore.
.PP
If the dump extends over more than one tape,
.I restore
will ask the user to change tapes.
If the
.B x
or
.B i
key has been specified,
.I restore
will also ask which volume the user wishes to mount.
The fastest way to extract a few files is to
start with the last volume, and work towards the first volume.
.PP
There are numerous consistency checks that can be listed by
.IR restore .
Most checks are self-explanatory or can ``never happen''.
Common errors are given below.
.IP "Converting to new file system format." 5n
.br
A dump tape created from the old file system has been loaded.
It is automatically converted to the new file system format.
.IP "<filename>: not found on tape" 5n
.br
The specified file name was listed in the tape directory,
but was not found on the tape.
This is caused by tape read errors while looking for the file,
and from using a dump tape created on an active file system.
.IP "expected next file <inumber>, got <inumber>" 5n
.br
A file that was not listed in the directory showed up.
This can occur when using a dump tape created on an active file system.
.IP "Incremental tape too low" 5n
.br
When doing incremental restore,
a tape that was written before the previous incremental tape,
or that has too low an incremental level has been loaded.
.IP "Incremental tape too high" 5n
.br
When doing incremental restore,
a tape that does not begin its coverage where the previous incremental 
tape left off,
or that has too high an incremental level has been loaded.
.IP "Tape read error while restoring <filename>" 5n
.ti -5n
.br
Tape read error while skipping over inode <inumber>
.ti -5n
.br
Tape read error while trying to resynchronize
.br
A tape read error has occurred.
If a file name is specified,
then its contents are probably partially wrong.
If an inode is being skipped or the tape is trying to resynchronize,
then no extracted files have been corrupted,
though files may not be found on the tape.
.IP "resync restore, skipped <num> blocks" 5n
.br
After a tape read error, 
.I restore
may have to resynchronize itself.
This message lists the number of blocks that were skipped over.
.SH FILES
/dev/rmt?	the default tape drive
.br
/tmp/rstdir*	file containing directories on the tape.
.br
/tmp/rstmode*	owner, mode, and time stamps for directories.
.br
\&./restoresymtable	information passed between incremental restores.
.SH SEE ALSO
rrestore(8C) dump(8), newfs(8), mount(8), mkfs(8)
.SH BUGS
.I Restore
can get confused when doing incremental restores from
dump tapes that were made on active file systems.
.PP
A level zero dump must be done after a full restore.
Because restore runs in user code,
it has no control over inode allocation;
thus a full restore must be done to get a new set of directories
reflecting the new inode numbering,
even though the contents of the files is unchanged.
