.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)quotaon.8	6.3 (Berkeley) 7/9/88
.\"
.TH QUOTAON 8 "July 9, 1988"
.UC 5
.SH NAME
quotaon, quotaoff \- turn file system quotas on and off
.SH SYNOPSIS
.B /etc/quotaon
[
.B \-v
]
.I filsys...
.PP
.B /etc/quotaon
[
.B \-v
]
.B \-a
.PP
.B /etc/quotaoff
[
.B \-v
]
.I filsys...
.PP
.B /etc/quotaoff
[
.B \-v
]
.B \-a
.SH DESCRIPTION
.I Quotaon
announces to the system that disc quotas should be enabled
on one or more file systems.
The file systems specified must have entries
in /etc/fstab and be mounted at the time.
The file system quota files must be present in the root
directory of the specified file system and be named
.IR quotas .
The optional argument
.B \-v
causes
.I quotaon
to print a message for each file system where quotas are turned on.
If, instead of a list of file systems, a
.B \-a
argument is give to 
.IR quotaon ,
all file systems in /etc/fstab marked read-write with quotas
will have their quotas turned on.  This is normally used at
boot time to enable quotas.
.PP
.I Quotaoff
announces to the system that file systems specified should
have any disc quotas turned off.  As above, the
.B \-v
forces a verbose message for each file system affected; and
the 
.B \-a
option forces all file systems in /etc/fstab to have their
quotas disabled.
.PP
These commands
update the status field of devices located in
.I /etc/mtab
to indicate when quotas are on or off for each file system.
.SH FILES
/etc/mtab	mount table
.br
/etc/fstab	file system table
.SH "SEE ALSO"
setquota(2),
mtab(5), fstab(5)
