.\" Copyright (c) 1983, 1987 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)newfs.8	6.6 (Berkeley) 10/1/87
.\"
.TH NEWFS 8 "October 1, 1987"
.UC 5
.SH NAME
newfs \- construct a new file system
.SH SYNOPSIS
.B /etc/newfs
[
.B \-N
] [
.B mkfs-options
]
.B special
.SH DESCRIPTION
.I Newfs
replaces the more obtuse
.IR mkfs (8)
program.
Before running 
.IR newfs ,
the disk must be labeled using 
.IR disklabel (8).
.I Newfs
builds a file system on the specified special device
basing its defaults on the information in the disk label.
Typically the defaults are reasonable, however
.I newfs
has numerous options to allow the defaults to be selectively overridden.
The
.B \-N
option causes the file system parameters to be printed out
without really creating the file system.
.PP
The following options define the general layout policies.
.TP 10
.B \-b block-size
The block size of the file system in bytes.  
.TP 10
.B \-f frag-size
The fragment size of the file system in bytes.
.TP 10
.B \-m free space %
The percentage of space reserved from normal users; the minimum
free space threshold.  The default value used is 10%.
See
.IR tunefs (8)
for more details on how to set this option.
.TP 10
.B \-o optimization preference (``space'' or ``time'')
The file system can either be instructed to try to minimize the time spent
allocating blocks, or to try to minimize the space fragmentation on the disk.
If the value of minfree (see above) is less than 10%,
the default is to optimize for space;
if the value of minfree greater than or equal to 10%,
the default is to optimize for time.
See
.IR tunefs (8)
for more details on how to set this option.
.TP 10
.B \-a maxcontig
This specifies the maximum number of contiguous blocks that will
be laid out before forcing a rotational delay (see \-d below).
The default value is one.
See
.IR tunefs (8)
for more details on how to set this option.
.TP 10
.B \-d rotdelay
This specifies the expected time (in milliseconds)
to service a transfer completion
interrupt and initiate a new transfer on the same disk.
The default is 4 milliseconds.
See
.IR tunefs (8)
for more details on how to set this option.
.TP 10
.B \-e maxbpg
This indicates the maximum number of blocks any single file can
allocate out of a cylinder group before it is forced to begin
allocating blocks from another cylinder group.
The default is about one quarter of the total blocks in a cylinder group.
See
.IR tunefs (8)
for more details on how to set this option.
.TP 10
.B \-i number of bytes per inode
This specifies the density of inodes in the file system.
The default is to create an inode for each 2048 bytes of data space.
If fewer inodes are desired, a larger number should be used;
to create more inodes a smaller number should be given.
.TP 10
.B \-c #cylinders/group
The number of cylinders per cylinder group in a file system.
The default value used is 16.
.TP 10
.B \-s size
The size of the file system in sectors.
.PP
The following options override the standard sizes for the disk geometry. 
Their default values are taken from the disk label.
Changing these defaults is useful only when using
.I newfs
to build a file system whose raw image will eventually be used
on a different type of disk than the one on which it is initially
created (for example on a write-once disk).
Note that changing any of these values from their
defaults will make it impossible for 
.I fsck
to find the alternate superblocks if the standard super block is lost.
.TP 10
.B \-r revolutions/minute
The speed of the disk in revolutions per minute.
.TP 10
.B \-S sector-size
The size of a sector in bytes (almost never anything but 512).
.TP 10
.B \-u sectors/track
The number of sectors/track available for data
allocation by the file system.
This does not include sectors reserved at the end of each track for
bad block replacement (see \fB\-p\fP below).
.TP 10
.B \-t #tracks/cylinder
The number of tracks/cylinder available for data
allocation by the file system.
.TP 10
.B \-p spare sectors per track
Spare sectors (bad sector replacements) are physical sectors
that occupy space at the end of each track.
They are not counted as part of the sectors/track (\fB\-u\fP)
since they are not available to the file system for data allocation.
.TP 10
.B \-x spare sectors per cylinder
Spare sectors (bad sector replacements) are physical sectors
that occupy space at the end of the last track in the cylinder.
They are deducted from the sectors/track (\fB\-u\fP)
of the last track of each cylinder
since they are not available to the file system for data allocation.
.TP 10
.B \-l hardware sector interleave
Used to describe perturbations in the media format to
compensate for a slow controller.
Interleave is physical sector interleave on each track,
specified as the denominator of the ratio:
.nf
	sectors read / sectors passed over
.fi
Thus an interleave of 1/1 implies contiguous layout, while 1/2
implies logical sector 0 is separated by one sector from logical
sector 1.
.TP 10
.B \-k sector 0 skew, per track
Used to describe perturbations in the media format to
compensate for a slow controller.
Track skew is the offset of sector 0 on track N
relative to sector 0 on track N-1 on the same cylinder.
.SH "SEE ALSO"
disktab(5),
fs(5),
disklabel(8),
diskpart(8),
fsck(8),
format(8),
tunefs(8)
.PP
M. McKusick, W. Joy, S. Leffler, R. Fabry,
``A Fast File System for UNIX'',
\fIACM Transactions on Computer Systems 2\fP, 3.
pp 181-197, August 1984.
(reprinted in the System Manager's Manual, SMM:14)
