/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	config.h,v $
 * Revision 2.1  90/10/27  20:43:37  dpj
 * Moving under MACH3 source control
 * 
 * Revision 1.29.1.2  90/10/21  21:46:41  dpj
 * 	Control the options from the MACH3_*** conditionals.
 * 
 * Revision 1.29.1.1  90/08/02  11:50:05  dpj
 * 	New MACH3 version.
 * 
 * Revision 1.29  89/08/01  18:19:14  mrt
 * 	Defs for mips boxes.
 * 	[89/07/14            af]
 * 
 * Revision 1.28  89/05/02  11:03:54  dpj
 * 	Fixed all files to conform to standard copyright/log format
 * 
 * Revision 1.27  89/04/24  20:35:15  dpj
 * 	Reorganized to list all option, including those that are
 * 	turned off.
 * 	Added options to disable the compilation of various security
 * 	and transport modules.
 * 	Removed declaration of conf_own_format, which breaks when this
 * 	file is included into a mig definitions file. Moved it to nm_defs.h.
 * 	[89/04/19  23:22:42  dpj]
 * 
 * Revision 1.26  88/10/21  11:41:22  mrt
 * turned off Camelot
 * 
 * Revision 1.25  88/10/08  22:34:42  dpj
 * 	Added USE_DELTAT.
 * 
 *  3-Sep-88  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added USE_DELTAT.
 *
 * 21-Jul-88  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added NOTIFY.
 *
 * 20-May-88  Mary Thompson (mrt) at Carnegie Mellon
 *	Added || (ns32000) to vax conditional in defining
 *	CONF_OWN_FORMAT
 *
 * 27-Feb-88  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added COMPAT.
 *
 * 21-Feb-88  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Reorganized into user-settable and fixed switches.
 *
 * 14-Dec-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added RPCMOD, CAMELOT, USE_TCP.
 *
 * 19-Aug-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added PORTSTAT.
 *
 * 30-Jul-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added NETPORT.
 *
 * 22-Jun-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added USE_VMTP condition.
 *
 * 12-Jun-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Defined KERNEL_FEATURES.
 *
 *  8-Jun-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added NM_USE_KDS condition - if on then start up and use a KDS.
 *
 * 19-May-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added NM_STATISTICS condition - if on then statistics are gathered.
 *
 * 30-Apr-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added LOCK_THREADS condition - if on only one thread can run at once.
 *
 * 16-Apr-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Only define debugging constants if they are not already defined.
 *
 * 13-Mar-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Added various debugging and tracing definitions.
 *
 *  6-Feb-87  Robert Sansom (rds) at Carnegie Mellon University
 *	Added conf_own_format - network order representation of CONF_OWN_FORMAT.
 *
 * 14-Dec-86  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Redefined the formats to be more general instead of having one
 *	for each machine type.
 *
 * 25-Nov-86  Robert Sansom (rds) at Carnegie Mellon University
 *	Moved src_format values from disp_hdr.h to here.
 *	Configure according to compiler preprocessor definitions.
 *
 * 15-Nov-86  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Created.
 *
 */
/*
 * config.h
 *
 *
 * $Header: /afs/cs.cmu.edu/project/mach-2/rcs/pkg/netmsg/conf/config.h,v 2.1 90/10/27 20:43:37 dpj Exp $
 *
 */

/*
 * Special definitions controlling the configuration of the Network Server.
 */


#ifndef	_CONFIG_
#define	_CONFIG_

/*
 * Attempt to figure-out the byte order if not already specified.
 */
#ifndef	BYTE_MSF
#if defined ( vax ) || defined ( ns32000 )
#define	BYTE_MSF		0
#endif
#if defined ( romp ) || defined ( sun )
#define	BYTE_MSF		1
#endif
#endif	BYTE_MSF

/*
 * Values for src_format
 */
#define DISP_FMT_NETWORK	0
#define DISP_FMT_VL_1		1	/* Vax order, long align */
#define DISP_FMT_NL_1		2	/* Non-vax order, long align */
#define DISP_FMT_MAX		(2 + 1)

/*
 * Format of the messages generated by servers on different machine types.
 */
#define	LongAlign		1
#if	BYTE_MSF
#define	CONF_OWN_FORMAT		DISP_FMT_NL_1
#define	VaxOrder		0
#else
#define	CONF_OWN_FORMAT		DISP_FMT_VL_1
#define	VaxOrder		1
#endif


#define	KERNEL_FEATURES	1

#define	PROF		0


/*
 * The following are switches that should be set before compiling the network
 * server. See the Network Server Design Document for details.
 */

/*
 * Debugging.
 */
#ifndef	NET_LOG
#define	NET_LOG		1
#endif	NET_LOG
#ifndef	NET_DEBUG
#define	NET_DEBUG	0
#endif	NET_DEBUG
#ifndef	NET_TRACE
#define	NET_TRACE	0
#endif	NET_TRACE
#ifndef	NET_PRINT
#define	NET_PRINT	0
#endif	NET_PRINT

/*
 * Misc features.
 */
#define	LOCK_THREADS	0
#define	NM_STATISTICS	1
#define	NETPORT		0
#define PORTSTAT	1
#define	RPCMOD		1
#define	COMPAT		0
#define	NOTIFY		0
#define	CAMELOT		0

/*
 * Modules that can be individually disabled.
 */
#define NM_USE_KDS	0
#define	USE_CRYPT	0
#define	USE_DES		0
#define	USE_MULTPERM	0
#define	USE_NEWDES	0
#define	USE_XOR		0
#define	USE_KEYMAN	0

/*
 * Transport protocols. In normal operation, DATAGRAM and SRR must always
 * be enabled. At least one of TCP, DELTAT or VMTP must alos be enabled.
 */
#define	USE_DATAGRAM		1
#define	USE_SRR			1
#define	USE_VMTP		0
#if	MACH3_SA || MACH3_US
#define	USE_TCP			0
#else	MACH3_SA || MACH3_US
#define	USE_TCP			1
#endif	MACH3_SA || MACH3_US
#if	MACH3
#define	USE_DELTAT		1
#else	MACH3
#define	USE_DELTAT		0
#endif

/*
 * Network interface. Enable only one.
 */
#if	MACH3
#if	MACH3_SA || MACH3_US
#define	USE_NETIPC_MACHNET	0
#define	USE_NETIPC_SOCKET	0
#define	USE_NETIPC_MACH3	1
#else	MACH3_SA || MACH3_US
#define	USE_NETIPC_MACHNET	0
#define	USE_NETIPC_SOCKET	1
#define	USE_NETIPC_MACH3	0
#endif	MACH3_SA || MACH3_US
#else	MACH3
#define	USE_NETIPC_MACHNET	1
#define	USE_NETIPC_SOCKET	0
#define	USE_NETIPC_MACH3	0
#endif	MACH3

#endif	_CONFIG_
