.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ncheck.8	6.2 (Berkeley) 1/13/86
.\"
.TH NCHECK 8 "January 13, 1986"
.UC 4
.SH NAME
ncheck \- generate names from i-numbers
.SH SYNOPSIS
.B /etc/ncheck
[
.B \-i
numbers ] [
.B \-a
] [
.B \-s
] filesystems ...
.SH DESCRIPTION
.B N.B.:
For most normal file system maintenance, the function of
.I ncheck
is subsumed by
.IR fsck (8).
.PP
.I Ncheck
with no options
generates a pathname vs. i-number
list of all files
on every specified filesystem.
Names of directory files are followed by `/\fB.\fR'.
The
.B \-i
option reduces the report to only those files whose i-numbers follow.
The
.B \-a
option
allows printing of the names
.RB ` . '
and
.RB ` .. ',
which are ordinarily suppressed.
The
.B \-s
option reduces the report to special files
and files with set-user-ID mode;
it is intended to discover concealed violations
of security policy.
.PP
The report is in no useful
order, and probably should be sorted.
.SH "SEE ALSO"
sort(1), dcheck(8), fsck(8), icheck(8)
.SH DIAGNOSTICS
When the filesystem structure is improper,
`??' denotes the `parent' of
a parentless file and
a pathname beginning with `...' denotes a loop.
