.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mount.8	6.1 (Berkeley) 4/27/85
.\"
.TH MOUNT 8 "April 27, 1985"
.UC 4
.SH NAME
mount, umount \- mount and dismount file system
.SH SYNOPSIS
.B /etc/mount
[ special name [
.B \-r
] ]
.PP
.B /etc/mount
.B \-a
.PP
.B /etc/umount
special
.PP
.B /etc/umount
.B \-a
.SH DESCRIPTION
.I Mount
announces to the system that a removable file system
is present on the device
.I special.
The file
.I name
must exist already; it
must be a directory (unless the root of the
mounted file system is not a directory).
It becomes the name of the newly mounted root.
The optional argument
.B \-r
indicates that the file system
is to be mounted read-only.
.PP
.I Umount
announces to the system that the removable file system previously
mounted on device
.I special
is to be removed.
.PP
If the
.B \-a
option is present for either
.I mount
or
.I umount,
all of the file systems described in
.I /etc/fstab
are attempted to be mounted or unmounted.
In this case,
.I special
and
.I name
are taken from
.I /etc/fstab.
The
.I special
file name from
.I /etc/fstab
is the block special name.
.PP
These commands
maintain a table of mounted devices in
.I /etc/mtab.
If invoked without an argument,
.I mount
prints the table.
.PP
Physically write-protected and magnetic tape file
systems must be mounted read-only
or errors will occur when access times are updated,
whether or not any explicit write is attempted.
.SH FILES
/etc/mtab	mount table
.br
/etc/fstab	file system table
.SH "SEE ALSO"
mount(2),
mtab(5), fstab(5)
.SH BUGS
Mounting file systems full of garbage will crash the system.
.br
Mounting a root directory on a non-directory
makes some apparently good pathnames invalid.
