.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mkproto.8	6.1 (Berkeley) 4/27/85
.\"
.TH MKPROTO 8 "April 27, 1985"
.UC 5
.SH NAME
mkproto \- construct a prototype file system
.SH SYNOPSIS
.B /etc/mkproto
special proto
.SH DESCRIPTION
.I Mkproto
is used to bootstrap a new file system.
First a new file system is created using
.IR newfs (8).
.I Mkproto 
is then used to copy files from the old file system into the new
file system according to the directions found in the prototype file
.I proto.
The prototype file
contains tokens separated by spaces or
new lines.
The first tokens comprise the specification
for the root directory.
File specifications consist of tokens
giving the mode,
the user-id,
the group id,
and the initial contents of the file.
The syntax of the contents field
depends on the mode.
.PP
The mode token for a file is a 6 character string.
The first character
specifies the type of the file.
(The characters
.B \-bcd
specify regular, block special,
character special and directory files
respectively.)
The second character of the type
is either
.B u
or
.B \-
to specify set-user-id mode or not.
The third is
.B g
or
.B \-
for the set-group-id mode.
The rest of the mode
is a three digit octal number giving the
owner, group, and other read, write, execute
permissions, see
.IR chmod (1).
.PP
Two decimal number
tokens come after the mode; they specify the
user and group ID's of the owner of the file.
.PP
If the file is a regular file,
the next token is a pathname
whence the contents and size are copied.
.PP
If the file is a block or character special file,
two decimal number tokens
follow which give the major and minor device numbers.
.PP
If the file is a directory,
.I mkproto
makes the entries
.BR . ""
and
.B  ..
and then
reads a list of names and
(recursively)
file specifications for the entries
in the directory.
The scan is terminated with the
token
.BR $ .
.PP
A sample prototype specification follows:
.PP
.nf
.in +5
d\-\-777 3 1
usr	d\-\-777 3 1
	sh	\-\-\-755 3 1 /bin/sh
	ken	d\-\-755 6 1
		$
	b0	b\-\-644 3 1 0 0
	c0	c\-\-644 3 1 0 0
	$
$
.in -5
.fi
.dt
.SH "SEE ALSO"
fs(5),
dir(5),
fsck(8),
newfs(8)
.SH BUGS
There should be some way to specify links.
.PP
There should be some way to specify bad blocks.
.PP
Mkproto can only be run on virgin file systems.
It should be possible to copy files into existent file systems.
